package com.bcxin.ars.model.sb;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.bcxin.ars.model.BaseModel;

import java.math.BigDecimal;

/**
 * 
 * <b>Function </b>出资人信息
 * 
 * @author LinQingLin
 * @date 2017年5月17日 上午9:48:42
 * @注意事项 </b>
 * <b>
 */
public class YearReportInvestor extends BaseModel{

    /**  */
	private static final long serialVersionUID = 8254911903743970042L;

    @ModelAnnotation(getName="年报ID",column = "yearReportId")
	private Long yearReportId;

    @ModelAnnotation(getName="用户ID",column = "userid")
	private Long userid;

	/**
	 * 出资人类型
	 */
    @ModelAnnotation(getName="出资人类型",column = "investors_type")
    private String investorsType;

    /**
     * 出资人姓名
     */
    @ModelAnnotation(getName="出资人姓名",column = "name")
    private String name;

    /**
     * 出资人身份证号
     */
    @ModelAnnotation(getName="出资人身份证号",column = "id_number")
    private String idNumber;

    /**
     * 民族
     */
    @ModelAnnotation(getName="民族",column = "nation")
    private String nation;

    /**
     * 户籍
     */
    @ModelAnnotation(getName="户籍",column = "address")
    private String address;

    /**
     * 国籍
     */
    @ModelAnnotation(getName="国籍",column = "national")
    private String national;

    /**
     * 性别
     */
    @ModelAnnotation(getName="性别",column = "sex")
    private String sex;

    /**
     * 手机号
     */
    @ModelAnnotation(getName="手机号",column = "phone")
    private String phone;

    /**
     * 地址
     */
    @ModelAnnotation(getName="地址",column = "nowaddress")
    private String nowaddress;

    /**
     * 出资金额
     */
    @ModelAnnotation(getName="出资金额",column = "funded_number")
    private BigDecimal fundedNumber;

    /**
     * 股份占比
     */
    @ModelAnnotation(getName="股份占比",column = "stock_proportion")
    private BigDecimal stockProportion;

    /**
     * 股权转让比例
     */
    @ModelAnnotation(getName="股权转让比例",column = "ratio_transfer")
    private BigDecimal ratioTransfer;

    /**
     * 转让前股东
     */
    @ModelAnnotation(getName="转让前股东",column = "shareholder_before")
    private String shareholderBefore;

    /**
     * 转让前股东比例
     */
    @ModelAnnotation(getName="转让前股东比例",column = "ratio_befor")
    private BigDecimal ratioBefor;

    /**
     * 股权变更时间
     */
    @ModelAnnotation(getName="股权变更时间",column = "transfer_time")
    private String transferTime;

    /**
     * 股权变更记录
     */
    @ModelAnnotation(getName="股权变更记录",column = "change_record")
    private String changeRecord;

    public String getChangeRecord() {
        return changeRecord;
    }

    public void setChangeRecord(String changeRecord) {
        this.changeRecord = changeRecord;
    }

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public BigDecimal getRatioTransfer() {
        return ratioTransfer;
    }

    public void setRatioTransfer(BigDecimal ratioTransfer) {
        this.ratioTransfer = ratioTransfer;
    }

    public String getShareholderBefore() {
        return shareholderBefore;
    }

    public void setShareholderBefore(String shareholderBefore) {
        this.shareholderBefore = shareholderBefore;
    }

    public BigDecimal getRatioBefor() {
        return ratioBefor;
    }

    public void setRatioBefor(BigDecimal ratioBefor) {
        this.ratioBefor = ratioBefor;
    }

    public String getTransferTime() {
        return transferTime;
    }

    public void setTransferTime(String transferTime) {
        this.transferTime = transferTime;
    }

    public Long getUserid() {
        return userid;
    }

    public void setUserid(Long userid) {
        this.userid = userid;
    }

    public String getInvestorsType() {
        return investorsType;
    }

    public void setInvestorsType(String investorsType) {
        this.investorsType = investorsType == null ? null : investorsType.trim();
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name == null ? null : name.trim();
    }

    public String getIdNumber() {
        return idNumber;
    }

    public void setIdNumber(String idNumber) {
        this.idNumber = idNumber == null ? null : idNumber.trim();
    }

    public String getNation() {
        return nation;
    }

    public void setNation(String nation) {
        this.nation = nation == null ? null : nation.trim();
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address == null ? null : address.trim();
    }

    public String getNational() {
        return national;
    }

    public void setNational(String national) {
        this.national = national == null ? null : national.trim();
    }

    public String getSex() {
        return sex;
    }

    public void setSex(String sex) {
        this.sex = sex == null ? null : sex.trim();
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone == null ? null : phone.trim();
    }

    public String getNowaddress() {
        return nowaddress;
    }

    public void setNowaddress(String nowaddress) {
        this.nowaddress = nowaddress == null ? null : nowaddress.trim();
    }

    public BigDecimal getFundedNumber() {
        return fundedNumber;
    }

    public void setFundedNumber(BigDecimal fundedNumber) {
        this.fundedNumber = fundedNumber;
    }

    public BigDecimal getStockProportion() {
        return stockProportion;
    }

    public void setStockProportion(BigDecimal stockProportion) {
        this.stockProportion = stockProportion;
    }

	public Long getYearReportId() {
		return yearReportId;
	}

	public void setYearReportId(Long yearReportId) {
		this.yearReportId = yearReportId;
	}
}