package com.bcxin.ars.model.sb;

import com.bcxin.ars.model.BusinessCommon;
import com.bcxin.ars.serializer.LongJsonDeserializer;
import com.bcxin.ars.serializer.LongJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;
import java.util.Date;
import com.bcxin.ars.model.BaseModel;


/**
 * 保安培训单位备案对象
 *
 * @table sb_trainrecord
 * @author lin
 * @date 2022-08-14
 */
@Data
public class Trainrecord extends BusinessCommon {

    private static final long serialVersionUID=1L;

    
    /**
     * 法人手机号码
     */
    private String legalPhone;
        
    /**
     * 办学许可证机关
     */
    private String organ;
        
    /**
     * 开办资金/注册资本
     */
    private String openAmount;
        
    /**
     * 法人名称
     */
    private String legalName;

    /**
     * 出资人证件类型
     */
    private String investorIdType;
        
    /**
     * 培训规模
     */
    private String trainScale;

    /**
     * 负责人手机号码
     */
    private String chargePhone;
        
    /**
     * 培训场地面积
     */
    private String siteArea;
        
    /**
     * 法人登记机关
     */
    private String enterOrg;

    /**
     * 负责人名称
     */
    private String chargeName;
        
    /**
     * 法人证件号码
     */
    private String idNum;
        
    /**
     * 办学许可证编号
     */
    private String licencenum;

        
    /**
     * 社会统一信用代码
     */
    private String socialCode;

    /**
     * 培训内容
     */
    private String trainContent;

    /**
     * 出资人名称
     */
    private String investor;

    /**
     * 出资方式
     */
    private String investMode;

    /**
     * 出资金额
     */
    private String investAmount;

    /**
     * 负责人证件号码
     */
    private String chargeIdNum;
        
    /**
     * 兼职教师人数
     */
    private String partNum;
        
    /**
     * 法人登记类型
     */
    private String enterType;

    /**
     * 法人审查状态
     */
    private String censorStatus;
        
    /**
     * 法人证件类型
     */
    private String idType;
        
    /**
     * 举办者姓名/名称
     */
    private String organizer;

    /**
     * 地址
     */
    private String address;

    /**
     * 出资人证件号码
     */
    private String investorIdNum;
        
    /**
     * 已开展保安培训情况简介
     */
    private String trainDesc;
        
    /**
     * 培训设施设备
     */
    private String trainEquip;

    /**
     * 负责人审查状态
     */
    private String chargeCensorStatus;
        
    /**
     * 负责人证件类型
     */
    private String chargeIdType;
        
    /**
     * 专职教师人数
     */
    private String fullNum;

    /**
     * 出资类型 1个人 2 企业
     */
    private String investorType;

    /**
     * 联系人
     */
    private String contact;
    /**
     * 联系电话
     */
    private String contactPhone;

    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long approvalid;

    private String nextPerson;
    
    @Override
    public boolean equals(Object o){
        return super.equals(o);
    }

    @Override
    public int hashCode(){
        return super.hashCode();
    }

}
