package com.bcxin.ars.model.sb;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.bcxin.ars.model.BusinessCommon;
import com.bcxin.ars.model.SecurityCompany;
import lombok.Data;

import java.util.Date;

/**
 * sb_trainChange
 * 法人变更
 * <b>Function </b>
 * 
 * @author LinQingLin
 * @date 2017年5月20日 下午12:36:31
 * @注意事项 </b>
 * <b>
 */
@Data
public class TrainChange extends BusinessCommon {

    /**  */
	private static final long serialVersionUID = -2892981931790662070L;

    private SecurityCompany securityCompany;

    /**
     * 原服务范围
     */
    @ModelAnnotation(getName="原服务范围",isExport = true,column  = "oldsecurityScopes")
    private String oldsecurityScopes;

    /**
     * 变更后服务范围
     */
    @ModelAnnotation(getName="变更后服务范围",isExport = true,column  = "securityScopes")
    private String securityScopes;

    /**
	 * 原公司名称
	 */
    @ModelAnnotation(getName="公司名称",isExport = true,column  = "oldcompanyname",defaultColumn = true)
	private String oldcompanyname;
    /**
     * 变更项目
     *
     */
    @ModelAnnotation(getName="变更项目",isExport = true,column  = "changeProject",defaultColumn = true,needTranslate = true,specialTranslateType = "3",dictName = "changeProject")
    private String changeProject;

	/**
	 * 原办公地址
	 */
    @ModelAnnotation(getName="原办公地址",isExport = true,column  = "oldaddress")
    private String oldaddress;

	/**
	 * 变更后办公地址
	 */
    @ModelAnnotation(getName="变更后办公地址",isExport = true,column  = "address")
    private String address;

	/**
	 * 许可证
	 */
    @ModelAnnotation(getName="许可证",isExport = true,column  = "licencenum")
    private String licencenum;

	/**
	 * 法人姓名
	 */
    @ModelAnnotation(getName="法人姓名",isExport = true,column  = "legalname",defaultColumn = true)
    private String legalname;

	/**
	 * 法人性别
	 */
    @ModelAnnotation(getName="法人性别",isExport = true,column  = "legalsex",needTranslate = true,dictName = "sex")
    private String legalsex;

	/**
	 * 任职时间
	 */
    @ModelAnnotation(getName="任职时间",isExport = true,column  = "officetime")
    private Date officetime;

	/**
	 * 证件类型
	 */
    @ModelAnnotation(getName="证件类型",isExport = true,column  = "trainCardtype",needTranslate = true,dictName = "idCardType")
    private String trainCardtype;

	/**
	 * 法人证件号码
	 */
    @ModelAnnotation(getName="法人证件号码",isExport = true,column  = "trainCardnumber")
    private String trainCardnumber;

	/**
	 * 拟定法人名称
	 */
    @ModelAnnotation(getName="拟定法人名称",isExport = true,column  = "ndlegalname")
    private String ndlegalname;

	/**
	 * 拟定法人性别
	 */
    @ModelAnnotation(getName="拟定法人性别",isExport = true,column  = "ndlegalsex",needTranslate = true,dictName = "sex")
    private String ndlegalsex;

	/**
	 * 拟定出生年月
	 */
    @ModelAnnotation(getName="拟定出生年月",isExport = true,column  = "ndlegalbrith")
    private String ndlegalbrith;

	/**
	 * 拟定法人文化程度
	 */
    @ModelAnnotation(getName="拟定法人文化程度",isExport = true,column  = "ndtrainCulture",needTranslate = true,dictName = "sex")
    private String ndtrainCulture;

	/**
	 * 拟定法人证件类型
	 */
    @ModelAnnotation(getName="拟定法人证件类型",isExport = true,column  = "ndtrainCardtype",needTranslate = true,dictName = "idCardType")
    private String ndtrainCardtype;

	/**
	 * 拟定法人证件号码
	 */
    @ModelAnnotation(getName="拟定法人证件号码",isExport = true,column  = "ndtrainCardnum")
    private String ndtrainCardnum;

	/**
	 * 拟定法人国籍
	 */
    @ModelAnnotation(getName="拟定法人国籍",isExport = true,column  = "ndlegalnationality")
    private String ndlegalnationality;

	/**
	 * 拟定法人手机号码
	 */
    @ModelAnnotation(getName="拟定法人手机号码",isExport = true,column  = "ndlegalphone")
    private String ndlegalphone;

	/**
	 * 拟定法人户籍所在地
	 */
    @ModelAnnotation(getName="拟定法人户籍所在地",isExport = true,column  = "ndlegaladdress")
    private String ndlegaladdress;

	/**
	 * 拟定法人实际地址
	 */
    @ModelAnnotation(getName="拟定法人实际地址",isExport = true,column  = "ndleaglsjaddress")
    private String ndleaglsjaddress;

    /**
     * 原法定代表人审查状态
     */
    @ModelAnnotation(getName="原法定代表人审查状态",isExport = true,column  = "trainCensorstatus")
    private String trainCensorstatus;

    /**
     *拟定法定代表人审查状态
     */
    @ModelAnnotation(getName="拟定法定代表人审查状态",isExport = true,column  = "ndtrainCensorstatus")
    private String ndtrainCensorstatus;

    /**
     *单位负责人审查状态(0 未审查 1 审查通过 2审查不通过）
     */
    @ModelAnnotation(getName="单位负责人审查状态",isExport = true,column  = "chargecensorstatus",needTranslate = true,dictName = "censorStatus")
    private String chargecensorstatus;

    /**
     * 原注册资本
     */
    @ModelAnnotation(getName="原注册资本",isExport = true,column  = "oldregisteredMoney")
    private String oldregisteredMoney;

    /**
     * 变更注册资本
     */
    @ModelAnnotation(getName="变更注册资本",isExport = true,column  = "bgregisteredMoney")
    private Double bgregisteredMoney;

    /**
     * 其他保安服务范围名称(保安范围为其他则此列必填)
     */
    @ModelAnnotation(getName="其他保安服务范围名称",isExport = true,column  = "otherSecScopeType")
    private String otherSecScopeType;


    @ModelAnnotation(getName="制证状态",isExport = true,column  = "cardState",needTranslate = true,dictName = "cardState")
    private String cardState;

    /***
     * 机构类型
     */
    private String institutionType;


    /***
     * 原发证日期
     */
    private String giveLicenseDate;

    /***
     * 到期换证备注
     */
    private String expireRemarks;

    //批准文号
    private String pzwh;

    //许可证号
    private String xkzh;

    //公司名称
    private String gsmc;

    //法人姓名
    private String frmc;


    //打印状态
    private String hasprint;

    //打印次数
    private String printcount;


    //打印时间
    private String printTime;

    //所属区域
    private String areacode;

    //所属区域
    private String fzrq;

    //正本PDF下载
    private String pdfpath;
    //副本PDF下载
    private String pdfpathRevese;

    //证书类型
    private String certificateType;

    //社会统一信用代码
    private String socialCode;

}