package com.bcxin.ars.model.sb;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.bcxin.ars.model.BaseModel;
import com.bcxin.ars.serializer.LongJsonDeserializer;
import com.bcxin.ars.serializer.LongJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;

/**
 *sb_personworkexperience
 *
 */
@Data
public class Personworkexperience extends BaseModel {

	/**
	 *单位
	 */
	@ModelAnnotation(getName="单位",column = "Companyname")
	private String companyname;

	/**
	 *职务
	 */
	@ModelAnnotation(getName="职务",column = "post")
	private String post;

	/**
	 *startdate	开始时间
	 */
	@ModelAnnotation(getName="开始时间",column = "startdate")
	private String startdate;

	/**
	 *结束时间
	 */
	@ModelAnnotation(getName="结束时间",column = "enddate")
	private String  enddate;

	/**
	 *保安证申请ID
	 */
	@JsonSerialize(using = LongJsonSerializer.class)
	@JsonDeserialize(using = LongJsonDeserializer.class)
	@ModelAnnotation(getName="保安证申请ID",column = "personcertificateid")
	private Long personcertificateid;

	/**
	 * 工作内容
	 */
	@ModelAnnotation(getName="工作内容",column = "workContent")
   private String workContent;

	/**
	 * 离职原因
	 */
	@ModelAnnotation(getName="离职原因",column = "liveReason")
	private String liveReason;

	/**
	 * 备注
	 */
	@ModelAnnotation(getName="备注",column = "Remarks")
	private String remarks;

}