package com.bcxin.ars.model.sb;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.bcxin.ars.model.BaseModel;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 
 * <b>Function </b>出资人信息
 * 
 * @author LinQingLin
 * @date 2017年5月17日 上午9:48:42
 * @注意事项 </b>
 * <b>
 */
@Data
public class Investor extends BaseModel{

    /**  */
	private static final long serialVersionUID = 8254911903743970042L;

    @ModelAnnotation(getName="用户ID",column = "userid")
	private Long userid;

	/**
	 * 出资人类型
	 */
    @ModelAnnotation(getName="出资人类型",column = "investors_type")
    private String investorsType;

    /**
     * 出资人姓名
     */
    @ModelAnnotation(getName="出资人姓名",column = "name")
    private String name;

    /**
     * 出资人身份证号
     */
    @ModelAnnotation(getName="出资人身份证号",column = "id_number")
    private String idNumber;

    /**
     * 民族
     */
    @ModelAnnotation(getName="民族",column = "nation")
    private String nation;

    /**
     * 地址
     */
    @ModelAnnotation(getName="地址",column = "address")
    private String address;

    /**
     * 国籍
     */
    @ModelAnnotation(getName="国籍",column = "national")
    private String national;

    /**
     * 性别
     */
    @ModelAnnotation(getName="性别",column = "sex")
    private String sex;

    /**
     * 手机号
     */
    @ModelAnnotation(getName="手机号",column = "phone")
    private String phone;

    /**
     * 现居住地址
     */
    @ModelAnnotation(getName="现居住地址",column = "nowaddress")
    private String nowaddress;

    /**
     * 出资金额
     */
    @JsonSerialize(using= ToStringSerializer.class)
    @ModelAnnotation(getName="出资金额",column = "funded_number")
    private BigDecimal fundedNumber;

    /**
     * 股份占比
     */
    @JsonSerialize(using= ToStringSerializer.class)
    @ModelAnnotation(getName="股份占比",column = "stock_proportion")
    private BigDecimal stockProportion;

    /**
     * 股权转让比例
     */
    @ModelAnnotation(getName="股权转让比例",column = "ratio_transfer")
    private BigDecimal ratioTransfer;

    /**
     * 转让前股东
     */
    @ModelAnnotation(getName="转让前股东",column = "shareholder_before")
    private String shareholderBefore;

    /**
     * 转让前股东比例
     */
    @ModelAnnotation(getName="转让前股东比例",column = "ratio_befor")
    private BigDecimal ratioBefor;

    /**
     * 股权变更时间
     */
    @ModelAnnotation(getName="股权变更时间",column = "transfer_time")
    private String transferTime;

    /**
     * 股权变更记录
     */
    @ModelAnnotation(getName="股权变更记录",column = "change_record")
    private String changeRecord;

    /**
     * 省份
     */
    @ModelAnnotation(getName="省份",column = "province")
    private String province;

    /**
     * 市
     */
    @ModelAnnotation(getName="市",column = "city")
    private String city;

    /**
     * 区县
     */
    @ModelAnnotation(getName="区县",column = "district")
    private String district;

    /**
     * 详细地址
     */
    @ModelAnnotation(getName="详细地址",column = "detail_address")
    private String detailAddress;


    /***
     * 公司许可证号
     */
    @ModelAnnotation(getName="公司许可证号",column = "abroadaddress")
    private String publicSecurityLicenseNumber;

    /**
     * 证件类型
     */
    @ModelAnnotation(getName="证件类型",column = "idCardType")
    private String idCardType;

    /**
     * 户籍
     */
    @ModelAnnotation(getName = "户籍",column = "huji")
    private String huji;

    /**
     * 公司名称
     */
    private String comName;

}