package com.bcxin.ars.model.sb;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.abcxin.smart.validator.annotation.ModelTableAnnotation;
import com.bcxin.ars.enums.MySqlDataFormatType;
import com.bcxin.ars.enums.SignType;
import com.bcxin.ars.model.BaseModel;
import lombok.Data;

import java.util.Date;

/**
 * 等级证实习记录
 */
@Data
@ModelTableAnnotation(extra = false)
public class GradePractice extends BaseModel {

    /** 人员id */
    private Long personId;

    /** 等级 */
    @ModelAnnotation(getName="等级",isExport = true,column  = "gradeLevel",needTranslate = true,dictName = "appraisalGrade")
    private String gradeLevel;

    /** 姓名 */
    @ModelAnnotation(getName="姓名",isExport = true,column  = "name",sign= SignType.LIKE)
    private String name;

    /** 身份证号 */
    @ModelAnnotation(getName="身份证号",isExport = true,column  = "idnum",sign= SignType.LIKE)
    private String idnum;

    /** 实习日期 */
    @ModelAnnotation(getName="实习日期",isExport = true,column  = "practiceDate")
    private String practiceDate;

    /** 实习单位id */
    private Long comId;

    /** 实习单位 */
    @ModelAnnotation(getName="实习单位",isExport = true,column  = "comName",sign= SignType.LIKE)
    private String comName;

    /** 上班打卡时间 */
    @ModelAnnotation(getName="上班打卡时间",isExport = true,column  = "startTime")
    private Date startTime;

    /** 下班打卡时间 */
    @ModelAnnotation(getName="下班打卡时间",isExport = true,column  = "endTime")
    private Date endTime;

    /** 时长 */
    @ModelAnnotation(getName="时长",isExport = true,column  = "duration",mySqlDataFormat = MySqlDataFormatType.MINUTE2HOUR_FLOAT_2)
    private Integer duration;

    /** 负责人 */
    @ModelAnnotation(getName="负责人",isExport = true,column  = "chargeName",sign= SignType.LIKE)
    private String chargeName;

    /** 负责人身份证号 */
    @ModelAnnotation(getName="负责人身份证号",isExport = true,column  = "chargeNo",sign= SignType.LIKE)
    private String chargeNo;

    /** 实习内容 */
    @ModelAnnotation(getName="实习内容",isExport = true,column  = "content",sign= SignType.LIKE)
    private String content;

    /** 穿戴保安服照 */
    private String uniformImg;

    /** 实习地点照片 */
    private String addressImg;

    /** 实习过程照片 */
    private String processImg;

    /** 实习过程视频 */
    private String video;

    /***
     * 实习开始时间
     */
    @ModelAnnotation(getName="实习开始时间",column  = "practiceDate",sign = SignType.DATE_GREATER_EQUAL)
    private String startPracticeDate;

    /***
     * 实习结束时间
     */
    @ModelAnnotation(getName="实习结束时间",column  = "practiceDate",sign = SignType.DATE_LESS_EQUAL)
    private String endPracticeDate;

}