package com.bcxin.ars.model.exam;

import java.math.BigDecimal;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.bcxin.ars.model.BaseModel;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;

/**
 * 考试人员信息
 * 
 * @author wangjianchi
 */
public class TrainExamPerson extends BaseModel {
	/**
	 * 
	 */
	private static final long serialVersionUID = -7159537238825959841L;

	private Long id;

	/**
	 * 考点ID
	 */
	@ModelAnnotation(getName="考点ID",column = "examID")
	private Long examID;

	/**
	 * 身份证号
	 */
	@ModelAnnotation(getName="身份证号",column = "identitynumber")
	private String identitynumber;

	/**
	 * 准考证
	 */
	@ModelAnnotation(getName="准考证",column = "ticket")
	private String ticket;

	/**
	 * 姓名
	 */
	@ModelAnnotation(getName="姓名",column = "fullname")
	private String fullname;

	/**
	 * 公司
	 */
	@ModelAnnotation(getName="公司",column = "company")
	private String company;

	/**
	 * 手机号码
	 */
	@ModelAnnotation(getName="手机号码",column = "mobile")
	private String mobile;

	/**
	 * 笔试成绩
	 */
	@ModelAnnotation(getName="笔试成绩",column = "writtenScore")
	private Integer writtenScore;

	/**
	 * 实操成绩
	 */
	@ModelAnnotation(getName="实操成绩",column = "operateScore")
	private Integer operateScore;

	/**
	 * 总成绩
	 */
	@ModelAnnotation(getName="总成绩",column = "sumScore")
	private BigDecimal sumScore;

	/**
	 * 考试状态(0:不合格,1:合格，空值则未录入)
	 */
	@ModelAnnotation(getName="考试状态",column = "testState")
	private String testState;

	/**
	 * 考试通知状态
	 */
	@ModelAnnotation(getName="考试通知状态",column = "noticeState")
	private String noticeState = "0";

	/**
	 * 成绩通知状态
	 */
	@ModelAnnotation(getName="成绩通知状态",column = "scoreMsgState")
	private String scoreMsgState = "0";

	/**
	 * 制证状态
	 */
	@ModelAnnotation(getName="制证状态",column = "cardState")
	private String cardState = "0";

	/**
	 * 性别(1:男，2：女)
	 */
	@ModelAnnotation(getName="性别",column = "sex")
	private String sex;

	/**
	 * 笔试状态(0:未开始,1:已完成)
	 */
	@ModelAnnotation(getName="笔试状态",column = "writtenState")
	private String writtenState = "0";

	/**
	 * 笔试考试信息:记录在线考试答题记录
	 */
	@ModelAnnotation(getName="笔试考试信息",column = "writtenRecord")
	private String writtenRecord;

	/**
	 * 保安员证人员ID
	 */
	@ModelAnnotation(getName="保安员证人员ID",column = "bbdPersonID")
	private Long bbdPersonID;

	/**
	 * 创建人
	 */
	@ModelAnnotation(getName="创建人",column = "create_by")
	private String createBy;

	/**
	 * 培训机构ID
	 */
	@ModelAnnotation(getName="培训机构ID",column = "organID")
	private String organID;

	/**
	 * 培训机构名称
	 */
	@ModelAnnotation(getName="培训机构名称",column = "organName")
	private String organName;

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getExamID() {
		return examID;
	}

	public void setExamID(Long examID) {
		this.examID = examID;
	}

	public String getIdentitynumber() {
		return identitynumber;
	}

	public void setIdentitynumber(String identitynumber) {
		this.identitynumber = identitynumber;
	}

	public String getTicket() {
		return ticket;
	}

	public void setTicket(String ticket) {
		this.ticket = ticket;
	}

	public String getFullname() {
		return fullname;
	}

	public void setFullname(String fullname) {
		this.fullname = fullname;
	}

	public String getCompany() {
		return company;
	}

	public void setCompany(String company) {
		this.company = company;
	}

	public String getMobile() {
		return mobile;
	}

	public void setMobile(String mobile) {
		this.mobile = mobile;
	}

	public Integer getWrittenScore() {
		return writtenScore;
	}

	public void setWrittenScore(Integer writtenScore) {
		this.writtenScore = writtenScore;
	}

	public Integer getOperateScore() {
		return operateScore;
	}

	public void setOperateScore(Integer operateScore) {
		this.operateScore = operateScore;
	}

	public BigDecimal getSumScore() {
		return sumScore;
	}

	public void setSumScore(BigDecimal sumScore) {
		this.sumScore = sumScore;
	}

	public String getTestState() {
		return testState;
	}

	public void setTestState(String testState) {
		this.testState = testState;
	}

	public String getNoticeState() {
		return noticeState;
	}

	public void setNoticeState(String noticeState) {
		this.noticeState = noticeState;
	}

	public String getScoreMsgState() {
		return scoreMsgState;
	}

	public void setScoreMsgState(String scoreMsgState) {
		this.scoreMsgState = scoreMsgState;
	}

	public String getCardState() {
		return cardState;
	}

	public void setCardState(String cardState) {
		this.cardState = cardState;
	}

	public String getSex() {
		return sex;
	}

	public void setSex(String sex) {
		this.sex = sex;
	}

	public String getWrittenState() {
		return writtenState;
	}

	public void setWrittenState(String writtenState) {
		this.writtenState = writtenState;
	}

	public String getWrittenRecord() {
		return writtenRecord;
	}

	public void setWrittenRecord(String writtenRecord) {
		this.writtenRecord = writtenRecord;
	}

	public Long getBbdPersonID() {
		return bbdPersonID;
	}

	public void setBbdPersonID(Long bbdPersonID) {
		this.bbdPersonID = bbdPersonID;
	}

	public String getCreateBy() {
		return createBy;
	}

	public void setCreateBy(String createBy) {
		this.createBy = createBy;
	}

	public String getOrganID() {
		return organID;
	}

	public void setOrganID(String organID) {
		this.organID = organID;
	}

	public String getOrganName() {
		return organName;
	}

	public void setOrganName(String organName) {
		this.organName = organName;
	}

}