package com.bcxin.ars.model.exam;

import java.util.Date;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.bcxin.ars.model.BaseModel;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;

/**
 * 考试基本信息
 */
public class TrainExamInfo extends BaseModel {

	private static final long serialVersionUID = -53900307772241552L;

	private Long id;
	/**
	 * 考点名称
	 */
	@ModelAnnotation(getName="考点名称",column = "examName")
	private String examName;

	/**
	 * 科目ID
	 */
	@ModelAnnotation(getName="科目ID",column = "subjectID")
	private Long subjectID;

	/**
	 * 考场地址
	 */
	@ModelAnnotation(getName="考场地址",column = "examPlace")
	private String examPlace;

	/**
	 * 考点交通
	 */
	@ModelAnnotation(getName="考点交通",column = "examTraffic")
	private String examTraffic;

	/**
	 * 是否理论考试(否:0,是:1)
	 */
	@ModelAnnotation(getName="是否理论考试",column = "isComputerExam")
	private int isComputerExam;

	/**
	 * 机考开始时间
	 */
	@ModelAnnotation(getName="机考开始时间",column = "computerStartDate")
	private Date computerStartDate;

	/**
	 * 机考结束时间
	 */
	@ModelAnnotation(getName="机考结束时间",column = "computerEndDate")
	private Date computerEndDate;

	/**
	 * 考点联系人
	 */
	@ModelAnnotation(getName="考点联系人",column = "examLinkMan")
	private String examLinkMan;

	/**
	 * 是否体能考试(否:0,是:1)
	 */
	@ModelAnnotation(getName="是否体能考试",column = "isStamina")
	private int isStamina;

	/**
	 * 理论考核地址
	 */
	@ModelAnnotation(getName="理论考核地址",column = "theoreticalAddress")
	private String theoreticalAddress;

	/**
	 * 操作技能考核地址
	 */
	@ModelAnnotation(getName="操作技能考核地址",column = "staminaAddress")
	private String staminaAddress;

	/**
	 * 体能测试开始时间
	 */
	@ModelAnnotation(getName="体能测试开始时间",column = "staminaStartDate")
	private Date staminaStartDate;

	/**
	 * 体能测试结束时间
	 */
	@ModelAnnotation(getName="体能测试结束时间",column = "staminaEndDate")
	private Date staminaEndDate;

	/**
	 * 注意事项
	 */
	@ModelAnnotation(getName="注意事项",column = "attention")
	private String attention;

	/**
	 * 笔试成绩比例
	 */
	@ModelAnnotation(getName="笔试成绩比例",column = "writtenRatio")
	private int writtenRatio;

	/**
	 * 实操成绩比例
	 */
	@ModelAnnotation(getName="实操成绩比例",column = "operateRatio")
	private int operateRatio;

	/**
	 * 成绩合格标准
	 */
	@ModelAnnotation(getName="成绩合格标准",column = "examStandard")
	private int examStandard;

	/**
	 * 考试状态(0:正常 1:取消)
	 */
	@ModelAnnotation(getName="考试状态",column = "examState")
	private String examState;

	/**
	 * 取消考试原因
	 */
	@ModelAnnotation(getName="取消考试原因",column = "cancelReason")
	private String cancelReason;

	/**
	 * 考试类型(1:线下,2:web,3:app)
	 */
	@ModelAnnotation(getName="考试类型",column = "examType")
	private String examType;

	/**
	 * 试卷ID
	 */
	@ModelAnnotation(getName="试卷ID",column = "paperID")
	private Long paperID;

	/**
	 * 行政区划编码
	 */
	@ModelAnnotation(getName="行政区划编码",column = "areaCode")
	private String areaCode;

	/**
	 * 理论考试合格分数
	 */
	@ModelAnnotation(getName="理论考试合格分数",column = "writtenPassScore")
	private int writtenPassScore;

	/**
	 * 操作技能合格分数
	 */
	@ModelAnnotation(getName="操作技能合格分数",column = "operatePassScore")
	private int operatePassScore;

	/**
	 * 成绩考核规则(1:设置每科通过分数线，双科都达到分数线则考试通过,2:不设置每科通过分数线，双科综合得分达标则考试通过)
	 */
	@ModelAnnotation(getName="成绩考核规则",column = "examRules")
	private int examRules;

	/**
	 * 创建人
	 */
	@ModelAnnotation(getName="创建人",column = "create_by")
	private String createBy;

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public String getExamName() {
		return examName;
	}

	public void setExamName(String examName) {
		this.examName = examName;
	}

	public Long getSubjectID() {
		return subjectID;
	}

	public void setSubjectID(Long subjectID) {
		this.subjectID = subjectID;
	}

	public String getExamPlace() {
		return examPlace;
	}

	public void setExamPlace(String examPlace) {
		this.examPlace = examPlace;
	}

	public String getExamTraffic() {
		return examTraffic;
	}

	public void setExamTraffic(String examTraffic) {
		this.examTraffic = examTraffic;
	}

	public int getIsComputerExam() {
		return isComputerExam;
	}

	public void setIsComputerExam(int isComputerExam) {
		this.isComputerExam = isComputerExam;
	}

	public Date getComputerStartDate() {
		return computerStartDate;
	}

	public void setComputerStartDate(Date computerStartDate) {
		this.computerStartDate = computerStartDate;
	}

	public Date getComputerEndDate() {
		return computerEndDate;
	}

	public void setComputerEndDate(Date computerEndDate) {
		this.computerEndDate = computerEndDate;
	}

	public String getExamLinkMan() {
		return examLinkMan;
	}

	public void setExamLinkMan(String examLinkMan) {
		this.examLinkMan = examLinkMan;
	}

	public int getIsStamina() {
		return isStamina;
	}

	public void setIsStamina(int isStamina) {
		this.isStamina = isStamina;
	}

	public String getStaminaAddress() {
		return staminaAddress;
	}

	public void setStaminaAddress(String staminaAddress) {
		this.staminaAddress = staminaAddress;
	}

	public String getTheoreticalAddress() {
		return theoreticalAddress;
	}

	public void setTheoreticalAddress(String theoreticalAddress) {
		this.theoreticalAddress = theoreticalAddress;
	}

	public Date getStaminaStartDate() {
		return staminaStartDate;
	}

	public void setStaminaStartDate(Date staminaStartDate) {
		this.staminaStartDate = staminaStartDate;
	}

	public Date getStaminaEndDate() {
		return staminaEndDate;
	}

	public void setStaminaEndDate(Date staminaEndDate) {
		this.staminaEndDate = staminaEndDate;
	}

	public String getAttention() {
		return attention;
	}

	public void setAttention(String attention) {
		this.attention = attention;
	}

	public int getWrittenRatio() {
		return writtenRatio;
	}

	public void setWrittenRatio(int writtenRatio) {
		this.writtenRatio = writtenRatio;
	}

	public int getOperateRatio() {
		return operateRatio;
	}

	public void setOperateRatio(int operateRatio) {
		this.operateRatio = operateRatio;
	}

	public int getExamStandard() {
		return examStandard;
	}

	public void setExamStandard(int examStandard) {
		this.examStandard = examStandard;
	}

	public String getExamState() {
		return examState;
	}

	public void setExamState(String examState) {
		this.examState = examState;
	}

	public String getCancelReason() {
		return cancelReason;
	}

	public void setCancelReason(String cancelReason) {
		this.cancelReason = cancelReason;
	}

	public String getExamType() {
		return examType;
	}

	public void setExamType(String examType) {
		this.examType = examType;
	}

	public Long getPaperID() {
		return paperID;
	}

	public void setPaperID(Long paperID) {
		this.paperID = paperID;
	}

	public String getAreaCode() {
		return areaCode;
	}

	public void setAreaCode(String areaCode) {
		this.areaCode = areaCode;
	}

	public int getWrittenPassScore() {
		return writtenPassScore;
	}

	public void setWrittenPassScore(int writtenPassScore) {
		this.writtenPassScore = writtenPassScore;
	}

	public int getOperatePassScore() {
		return operatePassScore;
	}

	public void setOperatePassScore(int operatePassScore) {
		this.operatePassScore = operatePassScore;
	}

	public int getExamRules() {
		return examRules;
	}

	public void setExamRules(int examRules) {
		this.examRules = examRules;
	}

	public String getCreateBy() {
		return createBy;
	}

	public void setCreateBy(String createBy) {
		this.createBy = createBy;
	}

}