package com.bcxin.ars.model.epidemic;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.bcxin.ars.model.BaseModel;
import lombok.Data;

/***
 * 疫情防控街道信息
 * @author subh
 */
@Data
public class RiskArea extends BaseModel {
    @ModelAnnotation(getName="区域编码",column  = "areaCode")
    private String areaCode;
    @ModelAnnotation(getName="街道名称",isExport = true,column  = "streetName",isGrid = true,width = "100px")
    private String streetName;
    @ModelAnnotation(getName="风险等级",isExport = true,column  = "riskLevel",isGrid = true,needTranslate = true,dictName ="riskLevel",width = "100px" )
    private String riskLevel;
    @ModelAnnotation(getName="区域名称",isExport = true,column  = "areaName",isGrid = true,needTranslate = true,dictName ="areaNameBJ",width = "100px")
    private String areaName;
    /***
     * 源ID
     */
    private Long sourceId;
}
