package com.bcxin.ars.model.certificate;


import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.abcxin.smart.validator.group.ThirdPartyTrain;
import com.bcxin.ars.enums.SignType;
import com.bcxin.ars.model.BaseModel;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Date;

/***
 * 等级证信息
 * @author subh
 */
@Data
public class GradeCertificate extends BaseModel {
    /**
     * 姓名
     */
    @NotBlank(message = "姓名不能为空", groups = {ThirdPartyTrain.class})
    @ModelAnnotation(getName = "姓名", column = "name", isExport = true, sign = SignType.LIKE)
    private String name;
    /**
     * 公民身份证号
     */
    @NotBlank(message = "身份证号不能为空", groups = {ThirdPartyTrain.class})
    @ModelAnnotation(getName = "公民身份证号", column = "idnum", isExport = true, sign = SignType.LIKE)
    private String idnum;
    /**
     * 培训时间
     */
    @NotNull(message = "培训时间不能为空", groups = {ThirdPartyTrain.class})
    @ModelAnnotation(getName = "培训时间", DATE_FORMAT = "%Y-%m-%d", column = "trainTime", isExport = true)
    private Date trainTime;
    /**
     * 鉴定时间 (发证日期)
     */
    @ModelAnnotation(getName = "鉴定时间", DATE_FORMAT = "%Y-%m-%d", column = "appraisalTime", isExport = true)
    private Date appraisalTime;

    @ModelAnnotation(getName = "发证日期", DATE_FORMAT = "%Y-%m-%d", column = "cerDate")
    private Date cerDate;

    /**
     * 等级
     */
    @NotBlank(message = "等级不能为空", groups = {ThirdPartyTrain.class})
    @ModelAnnotation(getName = "等级", column = "appraisalGrade", isExport = true, needTranslate = true, dictName = "appraisalGrade")
    private String appraisalGrade;
    /**
     * 等级证书编号
     */
    @NotBlank(message = "等级证书编号不能为空", groups = {ThirdPartyTrain.class})
    @ModelAnnotation(getName = "等级证书编号", column = "certificateNo", isExport = true, sign = SignType.LIKE)
    private String certificateNo;
    /**
     * 所在企业名称
     */
    @ModelAnnotation(getName = "所在企业名称", column = "companyName", isExport = true, sign = SignType.LIKE)
    private String companyName;
    /**
     * 公司ID
     */
    private Long companyId;
    /**
     * 人员ID
     */
    private Long personId;
    /**
     * 所在企业编码
     */
    @ModelAnnotation(getName = "所在企业编码", column = "companyCode")
    private String companyCode;
    /**
     * 培训机构名称
     */
    @NotBlank(message = "培训机构名称不能为空", groups = {ThirdPartyTrain.class})
    @ModelAnnotation(getName = "培训机构名称", column = "trainOrgName", isExport = true, sign = SignType.LIKE)
    private String trainOrgName;
    /**
     * 保安员编码
     */
    @ModelAnnotation(getName = "保安员编码", column = "securityCertificateNo", sign = SignType.LIKE)
    private String securityCertificateNo;
    /**
     * 保安员证书ID
     */
    private Long securityCertificateId;
    /**
     * 上传单位
     */
    @ModelAnnotation(getName = "上传单位", column = "uploadCompanyName")
    private String uploadCompanyName;
    /**
     * 培训种类
     */
    @ModelAnnotation(getName = "培训种类", column = "trainType")
    private String trainType;
    /***
     * 用户ID
     */
    @ModelAnnotation(getName = "用户ID", column = "userId")
    private Long userId;

    /**
     * 是否已推送给saas
     */
    private Boolean push;

    /**
     * 推送日期
     */
    private Date pushDate;
    /***
     * 培训开始时间
     */
    @NotNull(message = "培训开始时间不能为空", groups = {ThirdPartyTrain.class})
    @ModelAnnotation(getName = "培训开始时间", column = "trainTime", sign = SignType.DATE_GREATER_EQUAL)
    private String trainStartTime;

    /***
     * 培训结束时间
     */
    @ModelAnnotation(getName = "培训结束时间", column = "trainTime", sign = SignType.DATE_LESS_EQUAL)
    @NotNull(message = "培训结束时间不能为空", groups = {ThirdPartyTrain.class})
    private String trainEndTime;

    /***
     * 鉴定开始时间
     */
    @ModelAnnotation(getName = "鉴定开始时间", column = "appraisalTime", sign = SignType.DATE_GREATER_EQUAL)
    private String appraisalStartTime;

    /***
     * 鉴定结束时间
     */
    @ModelAnnotation(getName = "鉴定结束时间", column = "appraisalTime", sign = SignType.DATE_LESS_EQUAL)
    private String appraisalEndTime;

    /**
     * 在职状态
     */
    @ModelAnnotation(getName = "在职状态", column = "jobStatus", isExport = true, needTranslate = true, dictName = "incumbencyStatus")
    private String jobStatus;

    /**
     * 等级证报名id
     */
    @NotNull(message = "等级证报名id不能为空", groups = {ThirdPartyTrain.class})
    private Long personGradeId;
    /**
     * 培训机构id
     */
    @NotNull(message = "培训机构id不能为空", groups = {ThirdPartyTrain.class})
    private Long trainId;

    /**
     * 职业
     */
    private String profession;
    /**
     * 性别
     */
    private String gender;
    /**
     * 头像
     */
    private String headImg;

    /**
     * 二维码
     */
    private String qrCode;
}
