package com.bcxin.ars.model;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 安保公司和人员关系
 * @author Ethan
 */
@Data
public class SecurityCompanyPerson extends BaseModel {

	private static final long serialVersionUID = 5519637720022779284L;
	
	private Long nativeCode;
	
	@JSONField(serialize = false)
	@JsonBackReference
	@JsonIgnoreProperties(value={"handler"})
	private SecurityPerson person;
	
	@JsonIgnoreProperties(value={"handler"})
	private SecurityCompany company;

	@JsonIgnoreProperties(value={"handler"})
	private Organization org;

	/**
	 * 入职日期
	 */
	@ModelAnnotation(getName="入职日期",column = "entrydate")
	@DateTimeFormat(pattern = "yyyy-MM-dd")
	private Date entryDate;

	/**
	 *离职时间
	 */
	@ModelAnnotation(getName="离职时间",column = "leaveDate")
	@DateTimeFormat(pattern = "yyyy-MM-dd")
	private Date leaveDate;

	@Override
	public String toString() {
		return "SecurityCompanyPerson [person=" + person + ", company=" + company + ", org=" + org
				+ "]";
	}

	/**
	 * 勿删
	 * @param o
	 * @return
	 */
	@Override
	public boolean equals (Object o){
		return super.equals(o);
	}

	/**
	 * 勿删
	 * @return
	 */
	@Override
	public int hashCode() {
		return super.hashCode();
	}
	
}
