package com.bcxin.ars.model;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import lombok.Data;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 安保公司
 *
 * @author Ethan
 */
@Data
public class SecurityCompany extends BaseModel  {

    private static final long serialVersionUID = 2695124802911056702L;

    /**
     * 企业logo
     */
    private String userPhoto;
    /**
     * 用户名称
     */
    private String userRealname;

    /**
     * 联系方式
     */
    private String userPhone;


    /***
     * 登陆用户名
     */
    private String username;
    /**
     * 公司名称
     */
    @ModelAnnotation(getName="公司名称",column = "name",isExport = true,defaultColumn = true)
    private String name;
    /**
     * 社会统一信息代码
     */
    @ModelAnnotation(getName="社会统一信息代码",column = "social_code",isExport = true,defaultColumn = true)
    private String socialCode;
    /**
     * 法人
     */
    @ModelAnnotation(getName="法人",column = "legal_person",isExport = true,defaultColumn = true)
    private String legalPerson;

    /**
     * 法人身份证号
     */
    @ModelAnnotation(getName="法人身份证号",column = "legalPersonNo",isExport = true)
    private String legalPersonNo;

    /**
     * 0 未登录系统 1正常 2关闭 3吊销 4撤销
     * 0 未登录系统 1正常 4撤销
     */
    @ModelAnnotation(getName="公司状态",column = "companyState",isExport = true,defaultColumn = true,needTranslate = true,dictName = "companyState")
    private String companyState;
    /**
     * 账户信息
     */
    @JsonIgnoreProperties(value = {"handler"})
    private User user;

    /**
     * 邮政编码
     */
    @ModelAnnotation(getName="邮政编码",column = "postalcode",isExport = true)
    private String postalcode;

    /**
     * 区域编号
     */
    @ModelAnnotation(getName="区域编号",column = "native_code",isExport = true)
    private Long nativeCode;

    /**
     * 经办人姓名
     */
    @ModelAnnotation(getName="经办人姓名",column = "operatorname",isExport = false)
    private String operatorname;

    /**
     * 经办人手机
     */
    @ModelAnnotation(getName="经办人手机",column = "operatorphone",isExport = false)
    private String operatorphone;

    /**
     * 总公司名称
     */
    @ModelAnnotation(getName="总公司名称",column = "central_office_name",isExport = true)
    private String centralOfficeName;

    /**
     * 总公司法人
     */
    @ModelAnnotation(getName="总公司法人",column = "central_office_legal_person",isExport = true)
    private String centralOfficeLegalPerson;

    /**
     * 总公司电话
     */
    @ModelAnnotation(getName="总公司电话",column = "central_office_tel",isExport = true)
    private String centralOfficeTel;

    /**
     * 公司电话
     */
    @ModelAnnotation(getName="公司电话",column = "tel",isExport = true)
    private String tel;

    /**
     * 保安员数量
     */
    @ModelAnnotation(getName="保安员数量",column = "security_amount",isExport = false)
    private Integer securityAmount;
    /**
     * 排班保安员数量
     */
    @ModelAnnotation(getName="排班保安员数量",column = "schedulePersons")
    private Integer schedulePersons;
    /**
     * 在岗保安员数量
     */
    @ModelAnnotation(getName="在岗保安员数量",column = "onDutyPersons",isExport = false)
    private Integer onDutyPersons;
    /**
     * 不在岗保安员数量
     */
    @ModelAnnotation(getName="不在岗保安员数量",column = "notOnDutyPersons")
    private Integer notOnDutyPersons;
    /**
     * 未排班保安员数量
     */
    @ModelAnnotation(getName="未排班保安员数量",column = "noSchedulePersons")
    private Integer noSchedulePersons;
    /**
     *已投保安员
     */
    @ModelAnnotation(getName="已投保安员",column = "isuredNumber",isExport = false)
    private Integer isuredNumber;
    /**
     * 营业执照图片地址
     */
    @ModelAnnotation(getName="营业执照图片地址",column = "business_license",isExport = false)
    private String businessLicense;
    /**
     * 任务数量
     */
    @ModelAnnotation(getName="任务数量",column = "task_amount",isExport = false)
    private Integer taskAmount;

    /**
     * 省
     */
    @ModelAnnotation(getName="省",column = "province")
    private String province;

    /**
     * 市
     */
    @ModelAnnotation(getName="市",column = "city")
    private String city;

    /**
     * 县
     */
    @ModelAnnotation(getName="县",column = "area")
    private String area;

    /**
     * 所属地区编码
     */
    @ModelAnnotation(getName="所属地区编码",column = "areacode")
    private String areaCode;

    /**
     * 所属地区名称
     */
    @ModelAnnotation(getName="所属地区名称",column = "areaName",isExport = true,defaultColumn = true,specialTranslateType = "2",dictName = "areacode")
    private String areaName;


    /**
     * 办公地址
     */
    @ModelAnnotation(getName="办公地址",column = "location",isExport = true,defaultColumn = true)
    private String location;

    /**
     * 注册地址
     */
    @ModelAnnotation(getName="注册地址",column = "address")
    private String address;

    /**
     * 地点经度
     */
    @ModelAnnotation(getName="地点经度",column = "longitude")
    private String longitude;

    /**
     * 地点纬度
     */
    @ModelAnnotation(getName="地点纬度",column = "latitude")
    private String latitude;

    /**
     * 保单号
     */
    @ModelAnnotation(getName="保单号",column = "insurance_number",isExport = false)
    private String insuranceNumber;

    /**
     * 是否同意公安应急协议
     */
    @ModelAnnotation(getName="是否同意公安应急协议",column = "emergency_agreement")
    private Boolean emergencyAgreement;


    /**
     * 公安许可证
     */
    @ModelAnnotation(getName="公安许可证",column = "public_security_license",isExport = false)
    private String publicSecurityLicense;

    /**
     * 培训订单号
     */
    @ModelAnnotation(getName="培训订单号",column = "orderNo",isExport = false)
    private String orderNo;

    /**
     * 营业执照注册号
     */
    @ModelAnnotation(getName="营业执照注册号",column = "business_license_number",isExport = true)
    private String businessLicensNnumber;

    /**
     * 负责人
     */
    @ModelAnnotation(getName="负责人",column = "principal",isExport = true)
    private String principal;

    /**
     * 负责人电话
     */
    @ModelAnnotation(getName="负责人电话",column = "principal_phone",isExport = true)
    private String principalPhone;

    /**
     * 负责人身份证号
     */
    @ModelAnnotation(getName="负责人身份证号",column = "principal_id",isExport = true)
    private String principalId;

    /**
     * 注册资金
     */
    @ModelAnnotation(getName="注册资金",column = "registered_money",isExport = true,defaultColumn = true)
    private BigDecimal registeredMoney;

    /**
     * 固定资产
     */
    @ModelAnnotation(getName="固定资产",column = "fixed_assets",isExport = true)
    private BigDecimal fixedAssets;

    /**
     * 年营业额
     */
    @ModelAnnotation(getName="年营业额",column = "turnover_year",isExport = true)
    private BigDecimal turnoverYear;

    /**
     * 年利税
     */
    @ModelAnnotation(getName="年利税",column = "annual_profits",isExport = true)
    private BigDecimal annualProfits;

    /**
     * 保安服务许可证号
     */
    @ModelAnnotation(getName="保安服务许可证号",column = "public_security_license_number",isExport = true)
    private String publicSecurityLicenseNumber;

    @ModelAnnotation(getName = "发证机关名称",column = "give_license_name")
    private String giveLicenseName;
    /**
     * 发证日期
     */
    @ModelAnnotation(getName = "发证日期",column = "give_license_date")
    private Date giveLicenseDate;

    /**
     * 国籍
     */
    @ModelAnnotation(getName="国籍",column = "national",isExport = true)
    private String national;

    /**
     * 经济类型
     */
    @ModelAnnotation(getName="经济类型",column = "economic_type",isExport = true,needTranslate = true,dictName = "economicType")
    private String economicType;

    /**
     * 公司类型
     */
    @ModelAnnotation(getName="公司类型",column = "company_type",isExport = true,defaultColumn = true,needTranslate = true,dictName = "companyType")
    private String companyType;
    /**
     * 公司编码
     */
    private String companyCode;

    /**
     * 人力防范等级
     */
    @ModelAnnotation(getName="人力防范等级",column = "human_defense_level",isExport = true,needTranslate = true,dictName = "humanDefenseLevel")
    private String humanDefenseLevel;

    /**
     * 风险评估等级
     */
    @ModelAnnotation(getName="风险评估等级",column = "risk_assessment_level",isExport = true,needTranslate = true,dictName = "riskAssessmentLevel")
    private String riskAssessmentLevel;

    /**
     * 所属行业保安协会
     */
    @ModelAnnotation(getName="所属行业保安协会",column = "security_association",isExport = true,needTranslate = true,oneToMore = true,dictName = "securityAssociation")
    private String securityAssociation;

    /**
     * 法人股东经济类型
     */
    @ModelAnnotation(getName="法人股东经济类型",column = "economic_type_legal_person",isExport = true,needTranslate = true,dictName = "economicTypeLegalPerson")
    private String economicTypeLegalPerson;

    /**
     * 是否设立子公司
     */
    @ModelAnnotation(getName="是否设立子公司",column = "is_subsidiary",isExport = true)
    private String isSubsidiary;

    /**
     * 武装押运守护等级
     */
    @ModelAnnotation(getName="武装押运守护等级",column = "armed_escort_level",isExport = true,needTranslate = true,dictName = "armedEscortLevel")
    private String armedEscortLevel;

    /**
     * 安全技术防范等级
     */
    @ModelAnnotation(getName="安全技术防范等级",column = "security_technology_level",isExport = true,needTranslate = true,dictName = "securityTechnologyLevel")
    private String securityTechnologyLevel;

    /**
     * 是否线下购买保险
     */
    @ModelAnnotation(getName="是否线下购买保险",column = "policyLine",isExport = false,needTranslate = true,dictName = "policyLine")
    private String policyLine;

    /**
     * 机构类型
     */
    private String institutionType;

    /**
     * 保额
     */
    @ModelAnnotation(getName="保额",column = "insuranceAmount",isExport = false)
    String insuranceAmount;
    
    /**
     * 押运人员保额
     */
    @ModelAnnotation(getName="押运人员保额",column = "insuranceEscortAmount",isExport = false)
    String insuranceEscortAmount;

    /**
     * 保安服务范围名称
     */
    @ModelAnnotation(getName="服务范围名称",column = "securityScopeType",isExport = false)
    private String securityScopeType;

    /**
     * 其他保安服务范围名称(保安范围为其他则此列必填)
     */
    @ModelAnnotation(getName="其他服务范围名称",column = "otherSecScopeType",isExport = false)
    private String otherSecScopeType;


    /**
     * 保安公司类型 01-保安公司，02-武装押运，03-合资
     */
    private String sponsorlicenseType;

    /**
     * 监管机构名
     */
    private String orgName;

    /**
     * 监管机构id
     */
    private String orgId;

    /**
     * 区县监管机构名
     */
    private String districtOrgName;

    /**
     * 区县监管机构id
     */
    private String districtOrgId;


    private String product_name;
    private String insurance_ame;
    private String inception_date;
    private String planned_end_date;
    private String gross_premium;
    private String applicant_name;
    private String ins_count;

    /**
     * 初始化
     */
    @ModelAnnotation(getName="初始化",column = "init")
    private Boolean init;



    /**
     * 安保范围
     */
    @JsonManagedReference
    @JsonIgnoreProperties(value = {"handler"})
    private List<SecurityScope> securityScope = new ArrayList<SecurityScope>();

    /**
     * 数据迁移关联的外网id
     **/
    @ModelAnnotation(getName="外网id",column = "rawid")
    private Long rawid;

    /**
     * 数据迁移关联的内网id
     **/
    @ModelAnnotation(getName="内网id",column = "inrawid")
    private Long inrawid;

    /**
     * 内网是否导出的标记，导出后内网不允许修改
     **/
    @ModelAnnotation(getName="是否导出",column = "exported")
    private boolean exported;

    /**
     * saas主管理员账号对应的保安员person id
     * 用与saas创建公司时，同步给saas，需要百保盾这边同时创建主管理员账号
     */
    private Long perId;

    /**
     * saas主管理员账号对应的 主管理员手机号
     * 用与saas创建公司时，同步给saas，需要百保盾这边同时创建主管理员账号
     */
    private String mobilePhone;

    /**
     * 保安公司保险信息
     */
    private SecurityCompanyInsurance securityCompanyInsurance;
    /**
     * 公共服务平台企业ID
     */
    private String comId;

    /**
     * 排序
     */
    private Integer seq;

    /**
     * 上级总公司id
     */
    private String parentId;

    /**
     * 是否本地公司
     */
    private Boolean local;

    /**
     * 培训内容
     */
    private String trainContent;
    /***
     * 办公区域编码
     */
    private String officeAreaCode;

    /***
     * 办公区域监管机构ID
     */
    private String officeOrgId;
    /***
     * 办公区域监管机构名称
     */
    private String officeOrgName;
    /**
     * 勿删
     * @param o
     * @return
     */
    @Override
    public boolean equals (Object o){
        boolean retVal = false;
        if (o != null && o.getClass().equals(this.getClass())) {
            SecurityCompany that = (SecurityCompany) o;
            if (that.getId() != null && this.getId() != null){
                if (that.getId().intValue() == this.getId().intValue()) {
                    retVal = true;
                }
            }
        }
        return retVal;
    }

    /**
     * 勿删
     * @return
     */
    @Override
    public int hashCode() {
        return getId().hashCode();
    }

}
