package com.bcxin.ars.model;

import com.bcxin.ars.model.sb.BackgroundApproval;
import lombok.Data;

import java.util.List;


/**
 * 背景筛查问题记录对象
 *
 * @table problem_log
 * @author linqinglin
 * @date 2021-03-12
 */
@Data
public class ProblemLog extends BaseModel{

    private static final long serialVersionUID=1L;

                    
    /**
     * 业务类型
     */
    private String businessType;
        
    /**
     * 姓名
     */
    private String name;
        
    /**
     * 身份证号
     */
    private String idnum;
        
    /**
     * 业务主键id
     */
    private Long businessId;
        
    /**
     * 问题类型
     */
    private String problemType;

    /**
     * 问题
     */
    private String problem;

    /**
     * 违法犯罪详情
     */
    private String content;

    private List<BackgroundApproval> backgroundApprovals;
    
    @Override
    public boolean equals(Object o){
        return super.equals(o);
    }

    @Override
    public int hashCode(){
        return super.hashCode();
    }

}
