package com.bcxin.ars.model;

import com.abcxin.smart.validator.annotation.ModelAnnotation;

import java.util.Date;

/**
 * 
 * 交易订单信息表 
 * 
 * @author LinQingLin
 * @date 2017年4月6日 下午3:00:29
 * @注意事项 </b>
 * <b>
 */
public class OrderTransaction extends BaseModel{

    /**  */
	private static final long serialVersionUID = -7634304216768683007L;

	/**
    * 订单ID
    */
    @ModelAnnotation(getName="订单ID",column = "orderid")
    private Long orderid;

    /**
    * 订单号
    */
    @ModelAnnotation(getName="订单号",column = "ordernum")
    private String ordernum;

    /**
    * 付款时间
    */
    @ModelAnnotation(getName="付款时间",column = "paytime")
    private Date paytime;

    /**
    * 返回报文
    */
    @ModelAnnotation(getName="返回报文",column = "message")
    private String message;

    /**
    * 提交订单时间
    */
    @ModelAnnotation(getName="提交订单时间",column = "submitordertime")
    private Date submitordertime;

    /**
    * 付款状态 1待付款2付款成功3异常
    */
    @ModelAnnotation(getName="付款状态",column = "paystate")
    private String paystate;

    public Long getOrderid() {
        return orderid;
    }

    public void setOrderid(Long orderid) {
        this.orderid = orderid;
    }

    public String getOrdernum() {
        return ordernum;
    }

    public void setOrdernum(String ordernum) {
        this.ordernum = ordernum;
    }

    public Date getPaytime() {
        return paytime;
    }

    public void setPaytime(Date paytime) {
        this.paytime = paytime;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Date getSubmitordertime() {
        return submitordertime;
    }

    public void setSubmitordertime(Date submitordertime) {
        this.submitordertime = submitordertime;
    }

    public String getPaystate() {
        return paystate;
    }

    public void setPaystate(String paystate) {
        this.paystate = paystate;
    }
}