package com.bcxin.ars.model;

import com.bcxin.ars.model.datasync.FileRecordDetail;
import lombok.Data;

import java.util.List;

/**
 * 文件记录信息
 * @author Ethan
 */
@Data
public class Filerecord extends BaseModel {

	private static final long serialVersionUID = 7649752662428917609L;


	/**
	 * 文件路径
	 */
	private String filepath;

	/**
	 * 文件名
	 */
	private String filename;


	/**
	 *记录数量
	 */
	private Integer recordsize;

	/**
	 * 文件类型
	 */
	private String synchtype;

	private List<FileRecordDetail> errorDetailList;

	@Override
	public boolean equals (Object o){
		boolean retVal = false;
		if (o != null && o.getClass().equals(this.getClass())) {
			BaseModel that = (BaseModel) o;
			if (that.getId() != null && this.getId() != null){
				if (that.getId().intValue() == this.getId().intValue() && that.getUpdateTime().getTime() >= this.getUpdateTime().getTime()) {
					retVal = true;
				}
			}
		}
		return retVal;
	}

	@Override
	public int hashCode() {
		return getId().hashCode();
	}
}
