package com.bcxin.ars.model;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.bcxin.ars.enums.SignType;
import com.bcxin.ars.model.sys.Approval;
import com.bcxin.ars.serializer.LongJsonDeserializer;
import com.bcxin.ars.serializer.LongJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;

import java.util.Date;

/**
 * 审批业务表共有属性
 * @author linqinglin
 * @date 2019/03/08 0008 9:27
 */
@Data
public class BusinessCommon extends BaseModel {

    private String approvalContent;
    /**
     * 所在地省市县（区）
     **/
    @ModelAnnotation(getName="所在地省市县（区）",column = "szss",isExport = true)
    private String szss;

    /**
     * 所在地省代码
     **/
    @ModelAnnotation(getName="所在地省代码",column = "province")
    private String province;

    /**
     * 所在地市代码
     **/
    @ModelAnnotation(getName="所在地市代码",column = "city")
    private String city;

    /**
     * 所在地市机构id
     **/
    @ModelAnnotation(getName="所在地市机构id",column = "cityOrgId")
    private String cityOrgId;

    /**
     * 所在地县（区）代码
     **/
    @ModelAnnotation(getName="所在地县（区）代码",column = "district",isExport = true)
    private String district;
    /**
     * 所在地县（区）机构id
     **/
    @ModelAnnotation(getName="所在地县（区）机构id",column = "districtOrgId")
    private String districtOrgId;

    /**
     * 派出所ID
     */
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    @ModelAnnotation(getName="派出所ID",column = "orgid")
    private Long orgid;

    /**
     * 审批状态
     * 001未提交002待审核003审批通过004审批不通过
     */
    @ModelAnnotation(getName="审批状态",isExport = true,column  = "approvalstate",defaultColumn = true,needTranslate = true,dictName = "approvalState")
    private String approvalstate;

    /**
     * 派出所信息
     */
    private Police police;

    /**
     * 受理民警ID
     */
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    @ModelAnnotation(getName="受理民警ID",column = "policeid")
    private Long policeid;

    /***
     * 审批主键
     */
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long approvalId;

    /**
     * 审批数据
     *
     */
    private Approval approval;

    /**
     * 审批人
     */
    @ModelAnnotation(getName="审批人",isExport = true,column  = "approvalperson")
    private String approvalperson;

    /**
     * 审批原因
     */
    @ModelAnnotation(getName="审批原因",isExport = true,column  = "approvalreason")
    private String approvalreason;

    /**
     * 对外审批意见
     */
    private String outreason;
    /**
     * 审批时间
     */
    @ModelAnnotation(getName="审批时间",isExport = true,column  = "approvaldate")
    private Date approvaldate;

    /**
     * 压缩包地址
     */
    @ModelAnnotation(getName="压缩包地址",isExport = true,column  = "template_rar")
    private String templateRar;

    /**
     *公司名称
     */
    @ModelAnnotation(getName="公司名称",column = "Companyname",isExport = true,defaultColumn = true,sign= SignType.LIKE)
    private String companyname;

    /**
     * 公司id
     */
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    @ModelAnnotation(getName="公司id",isExport = true,column  = "companyid")
    private Long companyid;

    private SecurityCompany securityCompany;

    /**
     * 需要审批流程
     */
    private Boolean needApprove=true;

    @Override
    public boolean equals (Object o){
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}
