package com.bcxin.ars.export;

import com.bcxin.ars.enums.SignType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

/**
 * 学习进度导出where条件策略
 *
 * @author zhangyutong
 */
public class LearnRateExportWhereStrategy implements ExportWhereStrategy {
    private static final Logger logger = LoggerFactory.getLogger(LearnRateExportWhereStrategy.class);

    @Override
    public String spliceWhereStr(SignType signType, Map<String, String> columnMap, Map<Object, Object> searchParams, Object key) {

        String learnRate = (String) key;
        String whereStr = " and ";
        //字段名
        String column = columnMap.get(learnRate);
        logger.error(column);
        //表单查询字段值
        String value = (String) searchParams.get(learnRate);
        logger.error("search learnRate Value==>{}", value);
        //已完成 learnRate = 100
        if ("1".equals(value)) {
            whereStr += column + " = 100";
        }
        //未完成 learnRate < 100 && learnRate >= 0
        if ("0".equals(value)) {
            whereStr += column + " >= 0 and " + column + " < 100";
        }
        return whereStr;
    }
}
