package com.bcxin.ars.enums;

/**
 * 政务平台办件汇聚 类型
 * @author linqinglin
 * @date 2020/09/16 0016 14:23
 */
public enum MatterType {

    BAFWGS{
        @Override
        public String getBusinessCode(){return "001";}
        @Override
        public String getCode(){return "000109001000";}
        @Override
        public String getOrgType() {return "3"; }
        @Override
        public String getName(){return "保安服务公司设立许可";}
    },
    PXDW{
        @Override
        public String getBusinessCode(){return "002";}
        @Override
        public String getCode(){return "000109003000";}
        @Override
        public String getOrgType() {return "2"; }
        @Override
        public String getName(){return "设立保安培训单位审批";}
    },
    BAGSZGS{
        @Override
        public String getBusinessCode(){return "003";}
        @Override
        public String getCode(){return "111007016000";}
        @Override
        public String getOrgType() {return "3"; }
        @Override
        public String getName(){return "保安服务公司设立分公司备案";}
    },
    BAYZ{
        @Override
        public String getBusinessCode(){return "004";}
        @Override
        public String getCode(){return "000109004000";}
        @Override
        public String getOrgType() {return "2"; }
        @Override
        public String getName(){return "保安员证核发";}
    },
    KQYBAGS{
        @Override
        public String getBusinessCode(){return "005";}
        @Override
        public String getCode(){return "111007002000";}
        @Override
        public String getOrgType() {return "2"; }
        @Override
        public String getName(){return "外省市在京提供保安服务备案";}
    },
    ZXZY{
        @Override
        public String getBusinessCode(){return "006";}
        @Override
        public String getCode(){return "111007017000";}
        @Override
        public String getOrgType() {return "3"; }
        @Override
        public String getName(){return "自行招用保安员单位备案";}
    },
    FRBG{
        @Override
        public String getBusinessCode(){return "007";}
        @Override
        public String getCode(){return "000109002000";}
        @Override
        public String getOrgType() {return "2"; }
        @Override
        public String getName(){return "保安服务公司的法定代表人变更审核";}
    };

    public abstract String getBusinessCode();

    public abstract String getCode();

    public abstract String getOrgType();

    public abstract String getName();

    public static MatterType getByBusinessCode(String businessCode){
        switch (businessCode){
            case "001":
                return BAFWGS;
            case "002":
                return PXDW;
            case "003":
                return BAGSZGS;
            //case "004":
            //    return BAYZ;
            case "005":
                return KQYBAGS;
            case "006":
                return ZXZY;
            case "007":
                return FRBG;
            default:
                return null;
        }
    }
}
