package com.bcxin.ars.dto.task;

import com.bcxin.ars.serializer.LongJsonDeserializer;
import com.bcxin.ars.serializer.LongJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;

import java.sql.Time;
import java.util.Date;
@Data
public class PersonClockInDto {
    private static final long serialVersionUID = 1L;
    /**
     * 人员id
     */
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long personId;
    /**
     * 打卡日期
     *
     */
    private Date clockInDate;
    /**
     * 打卡时间
     */
    private Date clockInTime;
    /**
     * 上班时间
     *
     */
    private Time startWorkTime;
    /**
     * 下班时间
     *
     */
    private Time endWorkTime;
    /**
     * 班次规则ID
     *
     */
    private Long shiftRuleId;
    /**
     * 第几轮打卡
     *
     */
    private Integer clockInRound;
    /**
     * 打卡类型
     */
    private  String clockInType;
    /**
     *下班时间是否是次日
     */
    private String isEndNextDay;
}
