package com.bcxin.ars.dto.page;

import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.model.datasync.DataSyncLog;
import lombok.Data;

import java.util.Date;


/**
 * 数据同步记录查询dto
 *
 * @author lin
 * @date 2020-12-07
 */
@Data
public class DataSyncLogPageSearchDto extends SearchDto<DataSyncLog> {
    private static final long serialVersionUID = 1L;

    
    /**
     * 主键
     */
    private Long id;
    
    /**
     * 是否可用
     */
    private Boolean active;
    
    /**
     * 更新标识
     */
    private Boolean updateflag;
    
    /**
     * 是否内网
     */
    private Boolean intranet;
    
    /**
     * 创建时间
     */
    private Date createTime;
    
    /**
     * 修改时间
     */
    private Date updateTime;
    
    /**
     * 基础路径
     */
    private String basePath;
    
    /**
     * 文件路径
     */
    private String filePath;
    
    /**
     * 访问路径
     */
    private String url;
    
    /**
     * 类型 0业务数据 1客户上传附件 2警官上传附件
     */
    private String businessType;
    
    /**
     * 同步返回id
     */
    private Long msgId;
    
    /**
     * 同步状态
     */
    private String dataSyncState;
    
    /**
     * 开始时间
     */
    private String startDate;

    /**
     * 结束时间
     */
    private String endDate;
}
