package com.bcxin.ars.dto.page;

import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.model.sb.CerLearnRecord;
import lombok.Data;

import java.util.Date;


/**
 * 资格证/等级证学习记录查询dto
 *
 * @author lin
 * @date 2020-09-08
 */
@Data
public class CerLearnRecordPageSearchDto extends SearchDto<CerLearnRecord> {
    private static final long serialVersionUID = 1L;

    
    /**
     * 主键
     */
    private Long id;
    
    /**
     * 是否可用
     */
    private Boolean active;
    
    /**
     * 更新标识
     */
    private Boolean updateflag;
    
    /**
     * 创建时间
     */
    private Date createTime;
    
    /**
     * 修改时间
     */
    private Date updateTime;
    
    /**
     * 修改者
     */
    private String updateBy;
    
    /**
     * 数据区域
     */
    private String areaCode;
    
    /**
     * 姓名
     */
    private String name;
    
    /**
     * 身份证号
     */
    private String idNum;
    
    /**
     * 手机号
     */
    private String phone;
    
    /**
     * 人员id
     */
    private String perId;
    
    /**
     * 公司id
     */
    private String comId;
    
    /**
     * 现职企业
     */
    private String comName;
    
    /**
     * 所学课程名称
     */
    private String courseName;
    
    /**
     * 记录进度
     */
    private String progress;
    
    /**
     * 记录时间
     */
    private Date recordTime;
    
    /**
     * 记录地点
     */
    private String address;
    
    /**
     * 自拍照片
     */
    private String photo;

    /**
     * 记录类型 01 资格证 03 等级证
     */
    private String recordType;
    
    /**
     * 开始时间
     */
    private String startDate;

    /**
     * 结束时间
     */
    private String endDate;

    /**
     * 培训学校id
     */
    private String trainId;

    /**
     * 培训学校名称
     */
    private String trainName;


}
