package com.bcxin.ars.dto.gx;

import lombok.Data;

import javax.xml.bind.annotation.*;

/**
 * 属性才能被转换成xml中的标签
 */
@XmlAccessorType(XmlAccessType.FIELD)
/**
 * 指定根目录
 */
@XmlRootElement(name = "SPRENYUAN")
/***
 * XmlType 默认情况下，Jaxb编组出来的xml中的字段顺序是随机的，你可以使用@XmlType的propOrder属性
 */
@XmlType
@Data
public class IntegratedSprenyuan {

    /***
     * 手机号
     */
    @XmlElement(name = "LINKPHONE")
    private String LINKPHONE;
    /**
     * 身份证号
     */
    @XmlElement(name = "IDCARDNO")
    private String IDCARDNO;
    /***
     * 姓名
     */
    @XmlElement(name = "NAME")
    private String NAME;

}
