package com.bcxin.ars.dto.export;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.abcxin.smart.validator.annotation.ModelTableAnnotation;
import com.bcxin.ars.enums.SignType;
import lombok.Data;

import java.util.Date;

/**
 * sb_sponsorlicense
 * 保安服务公司许可证审批导出
 */
@Data
@ModelTableAnnotation()
public class SponsorlicenseExportDTO  {



	/**
     * 公司名称
     */
    @ModelAnnotation(getName="公司名称",column = "companyname",isExport = true,defaultColumn=true)
    private String companyname;

    /**
     * 提交时间（审批表）
     */
    @ModelAnnotation(getName="提交时间",column = "create_time",isExport = true,defaultColumn=true,anotherTable=true)
    private Date createTime;


    /**
     * 法人姓名
     */
    @ModelAnnotation(getName="法人姓名",column = "Representative",isExport = true,defaultColumn=true)
    private String representative;


    /**
     * 法人身份证号
     */
    @ModelAnnotation(getName="法人身份证号",column = "legalpersonno",isExport = true)
    private String legalPersonNo;

    /**
     *法人代表手机号
     */
    @ModelAnnotation(getName="法人代表手机号",column = "phone",isExport = true,defaultColumn=true)
    private String phone;


    /**
     *审批状态
     */
    @ModelAnnotation(getName="审批状态",column = "approvalstate",isExport = true,defaultColumn=true,needTranslate = true,dictName ="approvalState")
    private String approvalstate;
    /**
     * 下一个审批人（审批表）
     */
    @ModelAnnotation(getName="下一个审批人",column = "nextPerson",defaultColumn = true,isExport = true,anotherTable = true)
    private String nextPerson;
    /**
     * 电话
     */
    @ModelAnnotation(getName="公司电话",column = "Tel",isExport = true)
    private String tel;

    /**
     * 公司地址
     */
    @ModelAnnotation(getName="公司地址",column = "Address",isExport = true)
    private String address;

    /**
     * 邮编
     */
    @ModelAnnotation(getName="邮编",column = "Zipcode",isExport = true)
    private String zipcode;

    /**
     * 经营范围
     */
    @ModelAnnotation(getName="经营范围",column = "management",isExport = true,needTranslate = true,oneToMore = true,dictName ="securityScopeType")
    private String management;

    /**
     * 企业类型
     */
    @ModelAnnotation(getName="企业类型",column = "Enterprisetype",isExport = true)
    private String enterprisetype;

    /**
     * 注册资本
     */
    @ModelAnnotation(getName="注册资本",column = "Regcapital",isExport = true)
    private Integer regcapital;

    /**
     * 注册资本验资或评估机构
     */
    @ModelAnnotation(getName="注册资本验资或评估机构",column = "Assessmentorg",isExport = true)
    private String assessmentorg;

    /**
     * 货币资本
     */
    @ModelAnnotation(getName="货币资本",column = "currency",isExport = true)
    private Integer currency;

    /**
     * 货币资本百分比
     */
    @ModelAnnotation(getName="货币资本百分比",column = "currencybf",isExport = true)
    private String currencybf;
    /**
     * 货币评估资本百分比
     */
    @ModelAnnotation(getName="货币评估资本百分比",column = "currencyvaluebf",isExport = true)
    private String currencyvaluebf;

    /**
     *货币评估资本
     */
    @ModelAnnotation(getName="货币评估资本",column = "currencyvalue",isExport = true)
    private Integer currencyvalue;



    /**
     * 公司管理人员数
     */
    @ModelAnnotation(getName="公司管理人员数",column = "Companymanger",isExport = true)
    private Integer companymanger;

    /**
     *专业技术人员数
     */
    @ModelAnnotation(getName="专业技术人员数",column = "Technologynum",isExport = true)
    private Integer technologynum;

    /**
     * 公司用户面积
     */
    @ModelAnnotation(getName="公司用户面积",column = "Areanum",isExport = true)
    private String areanum;

    /**
     * 产权归属
     */
    @ModelAnnotation(getName="产权归属",column = "ascription",isExport = true)
    private String ascription;

    /**
     * 专属运输车辆数
     */
    @ModelAnnotation(getName="专属运输车辆数",column = "ascriptionvehicle",isExport = true)
    private Integer ascriptionvehicle;

    /**
     * 防暴枪支数
     */
    @ModelAnnotation(getName="防暴枪支数",column = "gunnum",isExport = true)
    private Integer gunnum;


    /**
     * 用户ID
     */
    @ModelAnnotation(getName="用户ID",column = "userid",isExport = true)
    private Long userid;
    
    /**
     * 受理民警ID
     */
    @ModelAnnotation(getName="受理民警ID",column = "policeid",isExport = true)
    private Long policeid;

    /**
     * 审批人
     */
    /*@ModelAnnotation(getName="审批人",column = "Approvalperson",isExport = true)*/
    private String approvalperson;

    /**
     * 审批时间
     */
    /*@ModelAnnotation(getName="审批时间",column = "approvaldate",isExport = true)*/
    private Date approvaldate;

    /**
     * 审批原因
     */
    /*@ModelAnnotation(getName="审批原因",column = "approvalreason",isExport = true)*/
    private String approvalreason;


    /**
     * 所在地省市县（区）
     **/
    @ModelAnnotation(getName="所在地省市县（区）",column = "szss",isExport = true)
    private String szss;

    /**
     * 所在地省代码
     **/
    @ModelAnnotation(getName="所在地省代码",column = "province")
    private String province;

    /**
     * 所在地市代码
     **/
    @ModelAnnotation(getName="所在地市代码",column = "city")
    private String city;

    /**
     * 所在地县（区）代码
     **/
    @ModelAnnotation(getName="所在地县（区）代码",column = "district",isExport = true,sign = SignType.LIKE)
    private String district;

    /**
     * 所在地县（区）代码
     **/
    @ModelAnnotation(getName="所在地县（区）代码",column = "district",isExport = true,sign = SignType.LIKE)
    private String areaCode;

    /**
     * 派出所ID
     */
    @ModelAnnotation(getName="派出所ID",column = "orgid")
    private Long orgid;
    

    /**
     * 派出所ID
     */
    @ModelAnnotation(getName="派出所ID",column = "orgid")
    private Long orgId;

    /**
     * 审查状态 0未审查 1 审查通过 2审查不通过
     */
    @ModelAnnotation(getName="审查状态",column = "censor_status",isExport = true,defaultColumn=true,needTranslate = true,dictName ="censorStatus")
    private String censorstatus;






    /***
     * 批复结果
     * 001 许可
     * 002 不许可
     * 003 整改
     */
    @ModelAnnotation(getName="批复结果",column = "reply_state",defaultColumn=true,needTranslate = true,dictName ="replyState")
    private String replyState;



    /**
     *制证状态    2已制证  0未制证  1提交审核
     */
    @ModelAnnotation(getName="制证状态",column = "card_state",isExport = true,defaultColumn=true,needTranslate = true,dictName ="cardState")
    private String cardState;

    /**
     * 批复，上传，制证按钮的标志位，在新审批中显示，旧审批中不显示
     * 1代表旧审批  空代表新审批
     */
    private String newOldFlag;

    /**
     * 其他保安服务范围名称(保安范围为其他则此列必填)
     */
    @ModelAnnotation(getName="其他保安服务范围名称",column = "otherSecScopeType",isExport = true)
    private String otherSecScopeType;


}