package com.bcxin.ars.dto.export;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.bcxin.ars.enums.SignType;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

@Data
public class SecurityPersonExportDto {
    /**
     * 保安员id
     */
    @ModelAnnotation(getName="保安员id",column = "id")
    private Long id;

    /**
     * 姓名
     */
    @ModelAnnotation(getName="姓名",column = "realname",isExport = true,sign= SignType.LIKE)
    private String realName;

    /**
     * 身份证号
     */
    @ModelAnnotation(getName="身份证号",column = "id_number",isExport = true,sign = SignType.LIKE)
    private String idNumber;

    /***
     * 资格证书号
     */
    @ModelAnnotation(getName="资格证书号",column = "zgcredential",isExport = true,sign = SignType.LIKE)
    private String zgcredential;

    /**
     * 公司名称
     */
    @ModelAnnotation(getName="公司名称",column = "companyName",isExport = true,sign= SignType.LIKE)
    private String companyName;

    /**
     * 公司id
     */
    @ModelAnnotation(getName="公司id",column = "companyId")
    private String companyId;

    /**
     * 监管机构
     */
    @ModelAnnotation(getName="监管机构",column = "orgName",isExport = true)
    private String orgName;

    /**
     * 监管分局
     */
    @ModelAnnotation(getName="监管分局",column = "districtOrgName",isExport = true)
    private String districtOrgName;

    /**
     * 分管机构
     */
    @ModelAnnotation(getName="分管机构",column = "orgId")
    private String orgId;

    /**
     * 资格证持证状态
     */
    @ModelAnnotation(getName="资格证持证状态",column = "certificateState",isExport = true,needTranslate = true,dictName = "certificateState")
    private String certificateState;

    /**
     * 实名认证
     */
    @ModelAnnotation(getName="实名认证",column = "identityAuthState",isExport = true,needTranslate = true,dictName = "identityAuthState")
    private String identityAuthState;

    @ModelAnnotation(getName="身份认证时间",column = "identityAuthTime",isExport = true,DATE_FORMAT= "%Y-%m-%d")
    private String identityAuthTime;

    /**
     * 人员类别   1内勤人员2普通保安员3武装押运人员
     */
    @ModelAnnotation(getName="人员类别",column = "personType",isExport = true,needTranslate = true,dictName = "personType")
    private String personType;

    /***
     * 性别
     */
    @ModelAnnotation(getName="性别",column = "gender",isExport = true,needTranslate = true,dictName = "sex")
    private String gender;

    /**
     * 在职状态
     */
    @ModelAnnotation(getName="在职状态",column = "incumbencyStatus",isExport = true,needTranslate = true,dictName = "incumbencyStatus")
    private String incumbencyStatus ;

    /**
     * 企业录入时间
     */
    @ModelAnnotation(getName="企业录入时间",column = "inputDate",isExport = true,DATE_FORMAT= "%Y-%m-%d %H:%i:%s")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date inputDate;
    /**
     * 入职日期
     */
    @ModelAnnotation(getName="入职日期",column = "entrydate",isExport = true,DATE_FORMAT= "%Y-%m-%d")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date entrydate;
    /**
     * 离职日期
     */
    @ModelAnnotation(getName="离职日期",column = "leaveDate",isExport = true,DATE_FORMAT= "%Y-%m-%d")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date leaveDate;

    /** 企业录入查询开始日期 */
    @ModelAnnotation(getName="企业录入查询开始日期",column = "inputDate",sign = SignType.DATE_GREATER_EQUAL)
    private String createStartDate;

    /** 企业录入查询结束日期 */
    @ModelAnnotation(getName="企业录入查询结束日期",column = "inputDate",sign = SignType.DATE_LESS_EQUAL)
    private String createEndDate;

    /** 入职查询开始日期 */
    @ModelAnnotation(getName="入职查询开始日期",column = "entrydate",sign = SignType.DATE_GREATER_EQUAL)
    private String startDate;

    /** 入职查询结束日期 */
    @ModelAnnotation(getName="入职查询结束日期",column = "entrydate",sign = SignType.DATE_LESS_EQUAL)
    private String endDate;

    /** 离职查询开始日期 */
    @ModelAnnotation(getName="离职查询开始日期",column = "leaveDate",sign = SignType.DATE_GREATER_EQUAL)
    private String leaveStartDate;

    /** 离职查询结束日期 */
    @ModelAnnotation(getName="离职查询结束日期",column = "leaveDate",sign = SignType.DATE_LESS_EQUAL)
    private String leaveEndDate;

    /** 未持证天数开始 */
    @ModelAnnotation(getName="未持证天数开始",column = "outTimeDay",sign = SignType.GREATER_EQUAL)
    private String startDay;

    /** 未持证天数结束 */
    @ModelAnnotation(getName="未持证天数结束",column = "outTimeDay",sign = SignType.LESS_EQUAL)
    private String endDay;

    /**
     * 身份证地址
     */
    @ModelAnnotation(getName="身份证地址",column = "id_card_address",isExport = true)
    private String idCardAddress;

    /**
     * 现居住地址
     */
    @ModelAnnotation(getName="现居住地址",column = "current_address",isExport = true)
    private String currentAddress;

    /**
     * 手机号
     */
    @ModelAnnotation(getName="手机号",column = "phone",isExport = true)
    private String phone;

    /**
     * 民族
     */
    @ModelAnnotation(getName="民族",column = "nation",isExport = true)
    private String nation;

    /**
     * 籍贯
     */
    @ModelAnnotation(getName="籍贯",column = "native")
    private Integer natives;

    /**
     * 户籍所在地
     */
    @ModelAnnotation(getName="户籍所在地",column = "nativeName",isExport = true)
    private String nativeName;
    /**
     * 身高
     */
    @ModelAnnotation(getName="身高",column = "stature",isExport = true)
    private Integer stature;

    /**
     * 血型
     */
    @ModelAnnotation(getName="血型",column = "blood",isExport = true)
    private String blood;

    /**
     * 年龄
     */
    @ModelAnnotation(getName="年龄",column = "age",isExport = true)
    private Integer age;

    /**
     * 学历
     */
    @ModelAnnotation(getName="学历",column = "edu",isExport = true,needTranslate = true,dictName = "edu")
    private String edu;

    /**
     * 职业水平
     */
    @ModelAnnotation(getName="职业水平",column = "profession_level",isExport = true,needTranslate = true,dictName = "professionLevel")
    private String professionLevel;

    /**
     * 证书号
     */
    @ModelAnnotation(getName="证书号",column = "credential",isExport = true)
    private String credential;

    @ModelAnnotation(getName="未持证工作天数",column = "outTimeDay",isExport = true)
    private String outTimeDay;

    /**
     * 是否购买意外险
     */
    @ModelAnnotation(getName="投保状态",column = "insured",isExport = true,needTranslate = true,dictName = "insuredState")
    private String insured;

    /**
     * 区域
     */
    @ModelAnnotation(getName="区域",column = "areacode",sign = SignType.LIKE_AREACODE)
    private String areaCode;

    /***
     * 户籍所在地
     */
    @ModelAnnotation(getName = "籍贯",column = "nativePlace")
    private String nativePlace;


    /***
     * 是否关联驻勤点
     */
    @ModelAnnotation(getName="是否关联驻勤点",column = "comTaskFlag",isExport = true,needTranslate = true,dictName = "comTaskFlag")
    private String comTaskFlag;

    /***
     * 驻勤点名称 导出太卡 不导
     */
    //@ModelAnnotation(getName="驻勤点名称",column = "taskName",isExport = true)
    //private String taskName;

    @ModelAnnotation(getName="驻勤点id",column = "comTaskId")
    private Long comTaskId;

    @ModelAnnotation(getName="临保任务id",column = "comTempTaskId")
    private Long comTempTaskId;

    @ModelAnnotation(getName="公司类型",column = "institutionType",sign = SignType.IN)
    private String institutionType;

}
