package com.bcxin.ars.dto.export;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.bcxin.ars.enums.SignType;
import com.bcxin.ars.model.BaseModel;
import com.bcxin.ars.model.User;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;

/**
 * 安保公司
 *
 * @author Ethan
 */
@Data
public class SecurityCompanyExportDTO extends BaseModel  {

    private static final long serialVersionUID = 2695124802911056702L;


    /**
     * 公司名称
     */
    @ModelAnnotation(getName="公司名称",column = "name",isExport = true,defaultColumn = true,sign = SignType.LIKE)
    private String name;
    /**
     * 社会统一信息代码
     */
    @ModelAnnotation(getName="社会统一信息代码证件号",column = "social_code",isExport = true,defaultColumn = true)
    private String socialCode;
    /**
     * 营业执照
     */
    @ModelAnnotation(getName="营业执照图片地址",column = "business_license" )
    private String businessLicense;
    /**
     * 法人
     */
    @ModelAnnotation(getName="法人",column = "legal_person",isExport = true,defaultColumn = true,sign = SignType.LIKE)
    private String legalPerson;
    /**
     * 法人手机号（user表）
     */
    @ModelAnnotation(getName="法人手机号",column = "phone",isExport = true,defaultColumn=true,sign = SignType.LIKE)
    private String phone;
    /**
     * 法人身份证号
     */
    @ModelAnnotation(getName="法人身份证号",column = "legalPersonNo",isExport = true,sign = SignType.LIKE)
    private String legalPersonNo;
    /**
     * 所属地区名称
     */
    @ModelAnnotation(getName="所属地区名称",column = "areaName",isExport = true,defaultColumn = true,specialTranslateType = "2",dictName = "areacode")
    private String areaName;
    /**
     * 注册资金
     */
    @ModelAnnotation(getName="注册资金",column = "registered_money",isExport = true,defaultColumn = true)
    private Double registeredMoney;
    /**
     * 公司类型
     */
    @ModelAnnotation(getName="公司类型",column = "company_type",isExport = true,defaultColumn = true,needTranslate = true,dictName = "companyType")
    private String companyType;
    /**
     * 账户信息
     */
    @JsonIgnoreProperties(value = {"handler"})
    private User user;
    /**
     * 邮政编码
     */
    @ModelAnnotation(getName="邮政编码",column = "postalcode",isExport = true)
    private String postalcode;

    /**
     *已投保安员
     */
    @ModelAnnotation(getName="已投保安员",column = "isuredNumber",isExport = true)
    private Integer isuredNumber;

    /**
     * 区域编号
     */
    @ModelAnnotation(getName="区域编号",column = "native_code",isExport = false)

    private Long nativeCode;


    /**
     * 经办人姓名
     */
    @ModelAnnotation(getName="经办人姓名",column = "operatorname" )
    private String operatorname;

    /**
     * 经办人手机
     */
    @ModelAnnotation(getName="经办人手机",column = "operatorphone" )
    private String operatorphone;


    /**
     * 公司状态
     */
    @ModelAnnotation(getName="公司状态",column = "state",needTranslate = true,dictName = "companyState",sign = SignType.OTHERIF)
    private String state;

    /**
     * 0 未登录系统 1正常 2关闭 3吊销 4撤销
     * 0 未登录系统 1正常 4撤销
     */
    @ModelAnnotation(getName="公司状态",column = "companyState",isExport = true,defaultColumn = true,needTranslate = true,dictName = "companyState")
    private String companyState;

    /**
     * 总公司名称
     */
    @ModelAnnotation(getName="总公司名称",column = "central_office_name",isExport = true)
    private String centralOfficeName;

    /**
     * 总公司法人
     */
    @ModelAnnotation(getName="总公司法人",column = "central_office_legal_person",isExport = true)
    private String centralOfficeLegalPerson;

    /**
     * 总公司电话
     */
    @ModelAnnotation(getName="总公司电话",column = "central_office_tel",isExport = true)
    private String centralOfficeTel;

    /**
     * 公司电话
     */
    @ModelAnnotation(getName="公司电话",column = "tel",isExport = true)
    private String tel;

    /**
     * 在职保安员数量
     */
    @ModelAnnotation(getName="在职保安员数量",column = "security_amount",isExport = true )
    private Integer securityAmount;

    /**
     * 任务数量
     */
    @ModelAnnotation(getName="任务数量",column = "task_amount" )
    private Integer taskAmount;

    /**
     * 省
     */
    @ModelAnnotation(getName="省",column = "province")
    private String province;

    /**
     * 市
     */
    @ModelAnnotation(getName="市",column = "city")
    private String city;

    /**
     * 县
     */
    @ModelAnnotation(getName="县",column = "area")
    private String area;

    /**
     * 所属地区编码
     */
    @ModelAnnotation(getName="所属地区编码",column = "areacode",sign = SignType.LIKE_AREACODE)
    private String areaCode;

    /**
     * 办公地址
     */
    @ModelAnnotation(getName="办公地址",column = "location",isExport = true,defaultColumn = true)
    private String location;

    /**
     * 地点经度
     */
    @ModelAnnotation(getName="地点经度",column = "longitude")
    private String longitude;

    /**
     * 地点纬度
     */
    @ModelAnnotation(getName="地点纬度",column = "latitude")
    private String latitude;

    /**
     * 保单号
     */
    @ModelAnnotation(getName="保单号",column = "insurance_number" )
    private String insuranceNumber;

    /**
     * 是否同意公安应急协议
     */
    @ModelAnnotation(getName="是否同意公安应急协议",column = "emergency_agreement")
    private Boolean emergencyAgreement;


    /**
     * 公安许可证
     */
    @ModelAnnotation(getName="公安许可证",column = "public_security_license")
    private String publicSecurityLicense;

    /**
     * 培训订单号
     */
    @ModelAnnotation(getName="培训订单号",column = "orderNo")
    private String orderNo;

    /**
     * 营业执照注册号
     */
    @ModelAnnotation(getName="营业执照注册号",column = "business_license_number",isExport = true)
    private String businessLicensNnumber;

    /**
     * 负责人
     */
    @ModelAnnotation(getName="负责人",column = "principal",isExport = true)
    private String principal;

    /**
     * 负责人电话
     */
    @ModelAnnotation(getName="负责人电话",column = "principal_phone")
    private String principalPhone;

    /**
     * 负责人身份证号
     */
    @ModelAnnotation(getName="负责人身份证号",column = "principal_id")
    private String principalId;



    /**
     * 固定资产
     */
    @ModelAnnotation(getName="固定资产",column = "fixed_assets",isExport = true)
    private Double fixedAssets;

    /**
     * 年营业额
     */
    @ModelAnnotation(getName="年营业额",column = "turnover_year",isExport = true)
    private Double turnoverYear;

    /**
     * 年利税
     */
    @ModelAnnotation(getName="年利税",column = "annual_profits",isExport = true)
    private Double annualProfits;

    /**
     * 保安服务许可证号
     */
    @ModelAnnotation(getName="保安服务许可证号",column = "public_security_license_number",isExport = true)
    private String publicSecurityLicenseNumber;

    /**
     * 国籍
     */
    @ModelAnnotation(getName="国籍",column = "national",isExport = true)
    private String national;

    /**
     * 经济类型
     */
    @ModelAnnotation(getName="经济类型",column = "economic_type",isExport = true,needTranslate = true,dictName = "economicType")
    private String economicType;


    /**
     * 公司编码
     */
    private String companyCode;

    /**
     * 分管机构
     */
    @ModelAnnotation(getName="分管机构",column = "districtOrgName",isExport = true)
    private String districtOrgName;

    /**
     * 监管机构
     */
    @ModelAnnotation(getName="监管机构",column = "orgName",isExport = true)
    private String orgName;

    /**
     * 分管机构Id
     */
    @ModelAnnotation(getName="分管机构Id",column = "orgId")
    private String orgId;


    /**
     * 人力防范等级
     */
    @ModelAnnotation(getName="人力防范等级",column = "human_defense_level",isExport = true,needTranslate = true,dictName = "humanDefenseLevel")
    private String humanDefenseLevel;

    /**
     * 风险评估等级
     */
    @ModelAnnotation(getName="风险评估等级",column = "risk_assessment_level",isExport = true,needTranslate = true,dictName = "riskAssessmentLevel")
    private String riskAssessmentLevel;

    /**
     * 所属行业保安协会
     */
    @ModelAnnotation(getName="所属行业保安协会",column = "security_association",isExport = true,needTranslate = true,oneToMore = true,dictName = "securityAssociation")
    private String securityAssociation;

    /**
     * 法人股东经济类型
     */
    @ModelAnnotation(getName="法人股东经济类型",column = "economic_type_legal_person",isExport = true,needTranslate = true,dictName = "economicTypeLegalPerson")
    private String economicTypeLegalPerson;

    /**
     * 是否设立子公司
     */
    @ModelAnnotation(getName="是否设立子公司",column = "is_subsidiary",isExport = true,needTranslate = true,dictName = "isSubsidiary")
    private String isSubsidiary;

    /**
     * 武装押运守护等级
     */
    @ModelAnnotation(getName="武装押运守护等级",column = "armed_escort_level",isExport = true,needTranslate = true,dictName = "armedEscortLevel")
    private String armedEscortLevel;

    /**
     * 安全技术防范等级
     */
    @ModelAnnotation(getName="安全技术防范等级",column = "security_technology_level",isExport = true,needTranslate = true,dictName = "securityTechnologyLevel")
    private String securityTechnologyLevel;

    /**
     * 注册地址
     */
    @ModelAnnotation(getName="注册地址",column = "address",isExport = true)
    private String address;

    /**
     * 是否线下购买保险
     */
    @ModelAnnotation(getName="是否线下购买保险",column = "policyLine",isExport = false,needTranslate = true,dictName = "policyLine")
    private String policyLine;


    /**
     * 机构类型
     */
    @ModelAnnotation(getName="机构类型",column = "institutionType",sign = SignType.IN)
    private String institutionType;

    /**
     * 保额
     */
    @ModelAnnotation(getName="保额",column = "insuranceAmount",isExport = false)
    String insuranceAmount;
    
    /**
     * 押运人员保额
     */
    @ModelAnnotation(getName="押运人员保额",column = "insuranceEscortAmount",isExport = false)
    String insuranceEscortAmount;
    @ModelAnnotation(getName="修改更新标志",column = "updateflag")
    private Boolean updateflag;

    /**
     * 其他保安服务范围名称(保安范围为其他则此列必填)
     */
    @ModelAnnotation(getName="其他保安服务范围名称",column = "otherSecScopeType",isExport = false)
    private String otherSecScopeType;
    /**
     * 保安服务范围名称
     */
    @ModelAnnotation(getName="服务范围",column = "securityScopeType",isExport = true,needTranslate = true,dictName = "securityScopeType",multipleCode = true,sign = SignType.LIKE,multipleCodeTableName = "v_security_company")
    private String securityScopeType;

    /**
     * 服务公司类型 01-保安公司，02-武装押运，03-合资
     */
    @ModelAnnotation(getName="服务公司类型",column = "sponsorlicenseType",isExport = false)
    private String sponsorlicenseType;

    private String product_name;
    private String insurance_ame;
    private String inception_date;
    private String planned_end_date;
    private String gross_premium;
    private String applicant_name;
    private String ins_count;

    /**
     * 初始化
     */
    @ModelAnnotation(getName="初始化",column = "init")
    private Boolean init;

    /**
     * 是否本地公司
     */
    @ModelAnnotation(getName="是否本地公司",column = "local")
    private Boolean local;
    
}
