package com.bcxin.ars.dto.export;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.abcxin.smart.validator.annotation.ModelTableAnnotation;
import com.bcxin.ars.enums.SignType;
import lombok.Data;

import java.util.Date;

/**
 * @author linqinglin
 * @date 2020/01/02 0002 13:46
 */
@Data
@ModelTableAnnotation(extra = false,tableName = "v_person_grade")
public class PersonGradeExPortDto {


    /** 人员id */
    @ModelAnnotation(getName="人员id",column = "personId")
    private Long personId;

    /** 姓名 */
    @ModelAnnotation(getName="姓名",column = "name",isExport = true,sign= SignType.LIKE)
    private String name;

    /** 手机号 */
    @ModelAnnotation(getName="手机号",column = "phone",isExport = true,sign= SignType.LIKE)
    private String phone;

    /** 身份证号 */
    @ModelAnnotation(getName="身份证号",column = "idNum",isExport = true,sign= SignType.LIKE)
    private String idNum;

    /**报名公司*/
    @ModelAnnotation(getName="报名公司",column = "comName",isExport = true,sign= SignType.LIKE)
    private String comName;

    /** 培训机构id */
    @ModelAnnotation(getName="培训机构id",column = "trainId")
    private Long trainId;

    /** 培训机构 */
    @ModelAnnotation(getName="培训机构",column = "trainName",isExport = true,sign= SignType.LIKE)
    private String trainName;

    /** 身份证正面 */
    private String idFrontImg;

    /** 身份证反面 */
    private String idBackImg;

    /** 头像 */
    private String headImg;

    /** 等级 */
    @ModelAnnotation(getName="等级",column = "gradeLevel",isExport = true,needTranslate = true,dictName = "appraisalGrade")
    private String gradeLevel;

    /** 报名时间 */
    @ModelAnnotation(getName="报名时间",column = "applyTime",isExport = true,DATE_FORMAT = "%Y-%m-%d %H:%i:%S")
    private Date applyTime;

    /**
     * 是否补考 1是 0否
     */
    @ModelAnnotation(getName="是否补考",column = "makeUp",isExport = true,needTranslate = true,dictName = "makeUp")
    private String makeUp;

    /** 学时进度 */
    @ModelAnnotation(getName="学时进度",column = "period",isExport = true)
    private String period;

    /** 实习天数 */
    @ModelAnnotation(getName="实习天数",column = "practiceDay",isExport = true)
    private Integer practiceDay;

    /** 实习时长 */
    @ModelAnnotation(getName="实习时长",column = "practiceHour",isExport = true)
    private Integer practiceHour;

    /** 背景筛查状态 */
    @ModelAnnotation(getName="背景筛查状态",column = "censorStatus",isExport = true,needTranslate = true,dictName = "gradeCensorStatus")
    private String censorStatus;

    /** 户籍地址 */
    @ModelAnnotation(getName="户籍地址",column = "address",isExport = true)
    private String address;

    /** 现住地址 */
    @ModelAnnotation(getName="现住地址",column = "liveAddress",isExport = true)
    private String liveAddress;

    /** 户籍类型 */
    @ModelAnnotation(getName="户籍类型",column = "residentType",isExport = true,needTranslate = true,dictName = "residentType")
    private String residentType;

    /** 户籍所在地类型 */
    @ModelAnnotation(getName="户籍所在地类型",column = "residentPlaceType",isExport = true,needTranslate = true,dictName = "residentPlaceType")
    private String residentPlaceType;

    /** 合同id */
    @ModelAnnotation(getName="合同id",column = "contractId")
    private Long contractId;

    /** 班级id */
    @ModelAnnotation(getName="班级id",column = "classId")
    private Long classId;

    /** 考试报名时间 */
    @ModelAnnotation(getName="考试报名时间",column = "testTime",isExport = true,DATE_FORMAT = "%Y-%m-%d %H:%i:%S")
    private Date testTime;

    /** 考试状态 */
    @ModelAnnotation(getName="鉴定考试状态",column = "testState",isExport = true,needTranslate = true,dictName = "testState")
    private String testState;

    /** 笔试成绩 */
    @ModelAnnotation(getName="鉴定笔试成绩",column = "writtenScore",isExport = true)
    private String writtenScore;

    /** 实操成绩 */
    @ModelAnnotation(getName="鉴定实操成绩",column = "operateScore",isExport = true)
    private String operateScore;

    /** 资格证号 */
    @ModelAnnotation(getName="资格证号",column = "zgCerNo",isExport = true)
    private String zgCerNo;

    /** 资格证电子证 */
    @ModelAnnotation(getName="资格证电子证",column = "zgCerUrl")
    private String zgCerUrl;

    /** 资格证发证机关 */
    @ModelAnnotation(getName="资格证发证机关",column = "zgOrg",isExport = true)
    private String zgOrg;

    /** 资格证培训单位 */
    @ModelAnnotation(getName="资格证培训单位",column = "zgTrainName",isExport = true)
    private String zgTrainName;

    /** 资格证发证日期 */
    @ModelAnnotation(getName="资格证发证日期",column = "zgIssueDate",isExport = true)
    private String zgIssueDate;

    /** 班级名称 */
    @ModelAnnotation(getName="班级名称",column = "className",isExport = true,sign= SignType.LIKE)
    private String className;

    /** 实操培训开班时间 */
    @ModelAnnotation(getName="实操培训开班时间",column = "trainTime",isExport = true)
    private String trainTime;

    /** 理论学习进度 */
    @ModelAnnotation(getName="理论学习进度",column = "periodStatus",sign = SignType.EQUAL_NULL_ZERO)
    private String periodStatus;

    /** 考试报名开始时间 */
    @ModelAnnotation(getName="考试报名开始时间",column = "testTime",sign = SignType.DATE_GREATER_EQUAL)
    private Date testStartTime;

    /** 考试报名结束时间 */
    @ModelAnnotation(getName="考试报名结束时间",column = "testTime",sign = SignType.DATE_LESS_EQUAL)
    private Date testEndTime;

    /** 报名开始时间  */
    @ModelAnnotation(getName="报名开始时间",column = "applyTime",sign = SignType.DATE_GREATER_EQUAL)
    private Date startTime;

    /** 报名结束时间 */
    @ModelAnnotation(getName="报名结束时间",column = "applyTime",sign = SignType.DATE_LESS_EQUAL)
    private Date endTime;

    /**
     * 结业考试结果 对应码表 testState
     *
     */
    @ModelAnnotation(getName="结业考试结果",column = "testStateComplete",isExport = true,needTranslate = true,dictName = "testState")
    private String testStateComplete;
    /**
     * 结业笔试成绩
     *
     */
    @ModelAnnotation(getName="结业笔试成绩",column = "writtenScoreComplete",isExport = true)
    private String writtenScoreComplete;
    /**
     * 结业实操成绩
     *
     */
    @ModelAnnotation(getName="结业实操成绩",column = "operateScoreComplete",isExport = true)
    private String operateScoreComplete;
    /**
     * 缴费时间
     *
     */
    @ModelAnnotation(getName="缴费时间",column = "payTime",isExport = true,DATE_FORMAT = "%Y-%m-%d %H:%i:%S")
    private Date payTime;
    /**
     * 系统首次录入时间
     *
     */
    @ModelAnnotation(getName="系统首次录入时间",column = "firtInputTime",isExport = true,DATE_FORMAT = "%Y-%m-%d %H:%i:%S")
    private Date firtInputTime;
    /**
     * 缴费状态 对应码表 feeState
     *
     */
    @ModelAnnotation(getName="缴费状态",column = "payState",isExport = true,needTranslate = true,dictName = "feeState")
    private String payState;
    /**
     * 材料核对状态
     *
     */
    @ModelAnnotation(getName="材料核对状态",column = "checkState",isExport = true,needTranslate = true,dictName = "checkState")
    private String checkState;
    /**
     * 开班安排状态
     *
     */
    @ModelAnnotation(getName="开班安排状态",column = "classState",isExport = true,needTranslate = true,dictName = "classState")
    private String classState;
    /**
     * 审批原因
     *
     */
    @ModelAnnotation(getName="审批原因",column = "approvalReason",isExport = true)
    private String approvalReason;
    /**
     * 申报状态
     *
     */
    @ModelAnnotation(getName="审批状态",column = "approvalState",isExport = true,needTranslate = true,dictName = "applyStatus")
    private String approvalState;
    /**
     * 人员类型
     *
     */
    @ModelAnnotation(getName="人员类型",column = "gradePersonType",isExport = true,needTranslate = true,dictName = "gradePersonType")
    private String gradePersonType;

    @ModelAnnotation(getName="数据区域",column = "areaCode",sign = SignType.LIKE)
    private String areaCode;

    @ModelAnnotation(getName="机构id",column = "orgId")
    private Long orgId;

    /** 比对状态 */
    @ModelAnnotation(getName="报名比对状态",column = "compareStatus",isExport = true,needTranslate = true,dictName = "compareStatus")
    private String compareStatus;

    /** 比对不通过原因 */
    @ModelAnnotation(getName="比对不通过原因",column = "compareReason",isExport = true)
    private String compareReason;

}
