package com.bcxin.ars.dto.export;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.bcxin.ars.enums.SignType;
import lombok.Data;

@Data
public class PersonAwardExportDto {
    /** 公司类型 */
    @ModelAnnotation(getName="公司类型",column = "institutionType",isExport = true,needTranslate = true,dictName ="institutionType")
    private String institutionType;

    /** 被表彰保安员 */
    @ModelAnnotation(getName = "被表彰保安员",column = "awarder",isExport = true,sign = SignType.LIKE)
    private String awarder;

    /** 被表彰人员身份证号 */
    @ModelAnnotation(getName = "被表彰人员身份证号",column = "idnum",isExport = true,sign = SignType.LIKE)
    private String idnum;

    /** 所属公司名称 */
    @ModelAnnotation(getName = "所属公司名称",column = "company_name",isExport = true,sign = SignType.LIKE)
    private String companyName;

    /** 表彰奖励时间 */
    @ModelAnnotation(getName = "表彰奖励时间",column = "award_date",isExport = true)
    private String awardDate;

    /** 表彰查询开始时间 */
    @ModelAnnotation(getName="表彰查询开始时间",column = "award_date",sign = SignType.DATE_GREATER_EQUAL)
    private String startDate;

    /** 表彰查询结束时间 */
    @ModelAnnotation(getName="表彰查询结束时间",column = "award_date",sign = SignType.DATE_LESS_EQUAL)
    private String endDate;

    /** 作出表彰单位 */
    @ModelAnnotation(getName = "作出表彰单位",column = "org_name",isExport = true,sign = SignType.LIKE)
    private String orgName;
    /** 作出表彰单位id */
    @ModelAnnotation(getName = "作出表彰单位id",column = "org_id",sign = SignType.EQUAL_NULL_ZERO)
    private String orgId;
    @ModelAnnotation(getName = "公安areaCode",column = "orgAreaCode",sign = SignType.LIKE_AREACODE)
    private String orgAreaCode;

    /** 作出表彰奖励决定的其他单位 */
    @ModelAnnotation(getName = "作出表彰奖励决定的其他单位",column = "other_org",isExport = true)
    private String otherOrg;

    /** 表彰奖励原因 */
    @ModelAnnotation(getName = "表彰奖励原因",column = "reason",isExport = true)
    private String reason;

    /** 表彰奖励内容 */
    @ModelAnnotation(getName = "表彰奖励内容",column = "content",isExport = true)
    private String content;

    /** 数据来源 */
    @ModelAnnotation(getName="数据来源",column = "dataSource",isExport = true,needTranslate = true,dictName ="dataSource")
    private String dataSource;

    /** 被检查人签名 */
    @ModelAnnotation(getName = "被检查人签名",column = "signImgPath",isExport = true)
    private String signImgPath;
}
