package com.bcxin.ars.dto.export;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.bcxin.ars.enums.SignType;
import com.bcxin.ars.model.BaseModel;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.model.sys.Approval;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 *sb_crosscompany
 *跨区域经营保安服务备案
 *
 */
@Data
public class CrosscompanyExportDTO extends BaseModel {

	/**  */
	private static final long serialVersionUID = -1641028410052142002L;


    /**
    *名称
    */
	@ModelAnnotation(getName="名称",isExport = true,column  = "Companyname",defaultColumn = true)
    private String companyname;
	/**
	 * 提交时间（审批表）
	 */
	@ModelAnnotation(getName="提交时间",column = "create_time",isExport = true,defaultColumn=true,anotherTable=true)
	private Date createTime;
	/**
	 *法人姓名
	 */
	@ModelAnnotation(getName="法人姓名",isExport = true,column  = "Legalname",defaultColumn = true)
	private String legalname;
	/**
	 *法人手机
	 */
	@ModelAnnotation(getName="法人手机",isExport = true,column  = "Legalphone",defaultColumn = true)
	private String legalphone;
	/**
	 *审批状态
	 */
	@ModelAnnotation(getName="审批状态",isExport = true,column  = "approvalstate",defaultColumn = true,needTranslate = true,dictName = "approvalState")
	private String approvalstate;

	/**
    *地址
    */
	@ModelAnnotation(getName="地址",isExport = true,column  = "address")
    private String address;

    /**
    *保安许可服务证号
    */
	@ModelAnnotation(getName="保安许可服务证号",isExport = true,column  = "Licencenum")
    private String licencenum;

    /**
    *邮编
    */
	@ModelAnnotation(getName="邮编",isExport = true,column  = "Zipcode")
    private String zipcode;

    /**
    *统一社会信用号码
    */
	@ModelAnnotation(getName="统一社会信用号码",isExport = true,column  = "Creditcode")
    private String creditcode;



    /**
    *法人性别
    */
	@ModelAnnotation(getName="法人性别",isExport = true,column  = "Legalsex",needTranslate = true,dictName = "sex")
    private String legalsex;

    /**
    *法人民族
    */
	@ModelAnnotation(getName="法人民族",isExport = true,column  = "Legalnation",needTranslate = true,dictName = "nation")
    private String legalnation;

    /**
    *法人出生年月
    */
	@ModelAnnotation(getName="法人出生年月",isExport = true,column  = "Legalbirth")
    private Date legalbirth;

    /**
    *法人政治面貌
    */
	@ModelAnnotation(getName="法人政治面貌",isExport = true,column  = "legalPolitics",needTranslate = true,dictName ="politics" )
    private String legalpolitics;

    /**
    *法人文化程度
    */
	@ModelAnnotation(getName="法人文化程度",isExport = true,column  = "legalCulture",needTranslate = true,dictName = "edu")
    private String legalculture;

    /**
    *法人办公电话
    */
	@ModelAnnotation(getName="法人办公电话",isExport = true,column  = "Legaltel")
    private String legaltel;



    /**
    *法人国籍
    */
	@ModelAnnotation(getName="法人国籍",isExport = true,column  = "Legalnationality")
    private String legalnationality;

    /**
    *法人证件类型
    */
	@ModelAnnotation(getName="法人证件类型",isExport = true,column  = "Legaltype",needTranslate = true,dictName = "idCardType")
    private String legaltype;

    /**
    *法人证件号码
    */
	@ModelAnnotation(getName="法人证件号码",isExport = true,column  = "Legalcardnumber")
    private String legalcardnumber;

    /**
    *法人实际居住地址
    */
	@ModelAnnotation(getName="法人实际居住地址",isExport = true,column  = "Legaladdress")
    private String legaladdress;

    /**
    *法人户籍所在址/境外地址
    */
	@ModelAnnotation(getName="法人户籍所在址/境外地址",isExport = true,column  = "legalAbroadaddress")
    private String legalabroadaddress;

    /**
    *拟跨区域经营的
    */
	@ModelAnnotation(getName="拟跨区域经营的",isExport = true,column  = "Managerproject")
    private String managerproject;

    /**
    *跨区域经营服务开始时间
    */
	@ModelAnnotation(getName="跨区域经营服务开始时间",isExport = true,column  = "Startdate")
    private Date startdate;

    /**
    *跨区域经营服务结束时间
    */
	@ModelAnnotation(getName="跨区域经营服务结束时间",isExport = true,column  = "enddate")
    private Date enddate;

    /**
    *拟跨区域经营地址
    */
	@ModelAnnotation(getName="拟跨区域经营地址",isExport = true,column  = "manageraddress")
    private String manageraddress;

    /**
    *负责人姓名
    */
	@ModelAnnotation(getName="负责人姓名",isExport = true,column  = "Chargename")
    private String chargename;

    /**
    *负责人职务
    */
	@ModelAnnotation(getName="负责人职务",isExport = true,column  = "Chargepost")
    private String chargepost;

    /**
    *负责人居民身份证号码
    */
	@ModelAnnotation(getName="负责人居民身份证号码",isExport = true,column  = "Chargecardnumber")
    private String chargecardnumber;

    /**
    *负责人联系电话
    */
	@ModelAnnotation(getName="负责人联系电话",isExport = true,column  = "Chargephone")
    private String chargephone;

    /**
    *子公司保安人数
    */
	@ModelAnnotation(getName="子公司保安人数",isExport = true,column  = "Sonpersonnum")
    private Integer sonpersonnum;

    /**
    *子公司邮编
    */
	@ModelAnnotation(getName="子公司邮编",isExport = true,column  = "Sonzipcode")
    private String sonzipcode;

    /**
	 * 压缩包地址
	 */
	@ModelAnnotation(getName="压缩包地址",isExport = true,column  = "template_rar")
	private String templateRar;
	
    /**
    *用户ID
    */
	@ModelAnnotation(getName="用户ID",isExport = true,column  = "userid")
    private Long userid;


    /**
    *审批人
    */
	/*@ModelAnnotation(getName="审批人",isExport = true,column  = "Approvalperson")*/
    private String approvalperson;

    /**
    *审批时间
    */
	/*@ModelAnnotation(getName="审批时间",isExport = true,column  = "approvaldate")*/
    private Date approvaldate;

    /**
    *审批原因
    */
	/*@ModelAnnotation(getName="审批原因",isExport = true,column  = "approvalreason")*/
    private String approvalreason;
	/**
	 * 审批信息列表
	 */
	private List approvallist;

	/**
	 * 审批信息
	 */
	private Approval approval;

	/**所在地省市县（区）**/
	@ModelAnnotation(getName="所在地省市县（区）",isExport = true,column  = "szss")
	private String szss;

	/**所在地省代码**/
	@ModelAnnotation(getName="所在地省代码",isExport = true,column  = "province")
	private String province;

	/**所在地市代码**/
	@ModelAnnotation(getName="所在地市代码",isExport = true,column  = "city")
	private String city;

	/**所在地县（区）代码**/
	@ModelAnnotation(getName="所在地县（区）代码",isExport = true,column  = "district",sign = SignType.LIKE)
	private String district;

    /**
     * 派出所ID
     */
	@ModelAnnotation(getName="派出所ID",isExport = true,column  = "orgid")
    private Long orgid;

	/**
	 * 派出所信息
	 */
	private Police police;

	public Police getPolice() {
		return police;
	}

	public void setPolice(Police police) {
		this.police = police;
	}
    
	/**
	 * 法人审核状态
	 */
	@ModelAnnotation(getName="法人审核状态",isExport = true,column  = "legalcensorstatus",needTranslate = true,dictName = "censorStatus")
	private String legalcensorstatus;

	/**
	 *单位负责人审查状态(0 未审查 1 审查通过 2审查不通过）
	 */
	@ModelAnnotation(getName="单位负责人审查状态",isExport = true,column  = "chargecensorstatus",needTranslate = true,dictName = "censorStatus")
	private String chargecensorstatus;

}