package com.bcxin.ars.dto.exam;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.model.exam.TrainExamPerson;

/**
 * 考试人员所有历史考试信息类
 *
 * @author wangjianchi
 */
public class TrainExamPersonHistoryDto extends SearchDto<TrainExamPerson> implements Serializable {

	private static final long serialVersionUID = -7289862224866368088L;
	/**
	 * 主键
	 */
	private String id;
	/**
	 * 身份证号
	 */
	private String identitynumber;
	/**
	 * 姓名
	 */
	private String fullname;
	/**
	 * 考试名称
	 */
	private String subjectID;
	/**
	 * 考试类型
	 */
	private String examType;
	/**
	 * 理论开始时间
	 */
	private Date computerStartDate;
	/**
	 * 理论结束时间
	 */
	private Date computerEndDate;
	/**
	 * 体能开始时间
	 */
	private Date staminaStartDate;
	/**
	 * 体能结束时间
	 */
	private Date staminaEndDate;
	/**
	 * 笔试成绩
	 */
	private Integer writtenScore;

	/**
	 * 实操成绩
	 */
	private Integer operateScore;

	/**
	 * 总成绩
	 */
	private BigDecimal sumScore;

	/**
	 * 考试状态
	 */
	private String testState;
	/**
	 * 第几页数(分页插件参数)
	 */
	protected Integer pageNum;
	/**
	 * 每页显示几条(分页插件参数)
	 */
	protected Integer numPerPage;

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getIdentitynumber() {
		return identitynumber;
	}

	public void setIdentitynumber(String identitynumber) {
		this.identitynumber = identitynumber;
	}

	public String getFullname() {
		return fullname;
	}

	public void setFullname(String fullname) {
		this.fullname = fullname;
	}

	public String getSubjectID() {
		return subjectID;
	}

	public void setSubjectID(String subjectID) {
		this.subjectID = subjectID;
	}

	public String getExamType() {
		return examType;
	}

	public void setExamType(String examType) {
		this.examType = examType;
	}

	public Date getComputerStartDate() {
		return computerStartDate;
	}

	public void setComputerStartDate(Date computerStartDate) {
		this.computerStartDate = computerStartDate;
	}

	public Date getComputerEndDate() {
		return computerEndDate;
	}

	public void setComputerEndDate(Date computerEndDate) {
		this.computerEndDate = computerEndDate;
	}

	public Date getStaminaStartDate() {
		return staminaStartDate;
	}

	public void setStaminaStartDate(Date staminaStartDate) {
		this.staminaStartDate = staminaStartDate;
	}

	public Date getStaminaEndDate() {
		return staminaEndDate;
	}

	public void setStaminaEndDate(Date staminaEndDate) {
		this.staminaEndDate = staminaEndDate;
	}

	public Integer getWrittenScore() {
		return writtenScore;
	}

	public void setWrittenScore(Integer writtenScore) {
		this.writtenScore = writtenScore;
	}

	public Integer getOperateScore() {
		return operateScore;
	}

	public void setOperateScore(Integer operateScore) {
		this.operateScore = operateScore;
	}

	public BigDecimal getSumScore() {
		return sumScore;
	}

	public void setSumScore(BigDecimal sumScore) {
		this.sumScore = sumScore;
	}

	public String getTestState() {
		return testState;
	}

	public void setTestState(String testState) {
		this.testState = testState;
	}

	@Override
	public Integer getPageNum() {
		return pageNum;
	}

	@Override
	public void setPageNum(Integer pageNum) {
		this.pageNum = pageNum;
	}

	@Override
	public Integer getNumPerPage() {
		return numPerPage;
	}

	@Override
	public void setNumPerPage(Integer numPerPage) {
		this.numPerPage = numPerPage;
	}
}
