package com.bcxin.ars.dto.conference;

import lombok.Data;

import java.util.Date;

/**
 * 华为云查询录播文件参数
 */
@Data
public class RecordDto {

    /**
     *会议预定者的用户UUID
     */
    private String userUUId;
    /**
     *页面索引,该值必须大于0；
     *
     * Default value : 0
     */
    private Integer offset;
    /**
     * 指定返回的记录数,默认值由会议AS定义，默认值为“20”，最大值为“100”。
     */
    private Integer limit;
    /**
     * 指定是否查询企业下所有用户的会议录播文件
     */
    private Boolean queryAll;
    /**
     * 会议主题，预定人或会议id可作为搜索词，查询录播文件
     */
    private String searchKey;
    /**
     * 查询的起始日期毫秒数
     */
    private Date startDate;
    /**
     * 查询的截止日期毫秒数
     */
    private Date endDate;
    /**
     * ASC_StartTIME：按录制开始时间升序排序。
     * DSC_StartTIME：按录制开始时间降序排序。
     */
    private String sortType;
}
