package com.bcxin.ars.dto.conference;

import lombok.Data;

import java.io.Serializable;

/**
 * 云会议室
 * @author zhangyutong
 */
@Data
public class CloudConferenceRoom implements Serializable {

    private String id;
    /**
     * 云会议室ID
     */
    private String vmrId;

    /**
     * 云会议室名称
     */
    private String vmrName;

    /**
     * 云会议室套餐名称
     */
    private String vmrPkgName;

    /**
     * 云会议室套餐会议并发方数
     */
    private Integer vmrPkgParties;

    /**
     *云会议室状态。
     *
     * 0:正常
     * 1:冻结
     * 2:未分配
     */
    private Integer status;

    /**
     * 云会议绑定账号id为用户账号
     */
    private CloudConferenceRoomMember member;

    /**
     * 云会议绑定硬终端账号id为硬终端账号
     */
    private CloudConferenceRoomDevice device;
}
