package com.bcxin.ars.dto.certificate;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.enums.SignType;
import com.bcxin.ars.model.certificate.GradeCertificate;
import lombok.Data;

import java.util.Date;

/***
 * 等级证信息
 * @author subh
 */
@Data
public class GradeCertificateSearchDto extends SearchDto<GradeCertificate> {

    /** 姓名 */
    @ModelAnnotation(getName="姓名",column = "name",isExport = true,sign= SignType.LIKE)
    private String name;
    /** 公民身份证号 */
    @ModelAnnotation(getName="公民身份证号",column = "idnum",isExport = true,sign= SignType.LIKE)
    private String idnum;
    /** 培训时间 */
    @ModelAnnotation(getName="培训时间",DATE_FORMAT= "%Y-%m-%d",column = "trainTime",isExport = true)
    private Date trainTime;
    /** 鉴定时间 */
    @ModelAnnotation(getName="鉴定时间",DATE_FORMAT= "%Y-%m-%d",column = "appraisalTime",isExport = true)
    private Date appraisalTime;
    /** 等级 */
    @ModelAnnotation(getName="等级",column = "appraisalGrade",isExport = true,needTranslate = true,dictName = "appraisalGrade")
    private String appraisalGrade;
    /** 等级证书编号 */
    @ModelAnnotation(getName="等级证书编号",column = "certificateNo",isExport = true,sign= SignType.LIKE)
    private String certificateNo;
    /** 所在企业名称 */
    @ModelAnnotation(getName="所在企业名称",column = "companyName",isExport = true,sign= SignType.LIKE)
    private String companyName;
    /** 公司ID */
    private Long companyId;
    /** 人员ID */
    private Long personId;
    /** 所在企业编码 */
    @ModelAnnotation(getName="所在企业编码",column = "companyCode")
    private String companyCode;
    /** 培训机构名称 */
    @ModelAnnotation(getName="培训机构名称",column = "trainOrgName",isExport = true,sign= SignType.LIKE)
    private String trainOrgName;
    /** 保安员编码 */
    @ModelAnnotation(getName="保安员编码",column = "securityCertificateNo",sign= SignType.LIKE)
    private String securityCertificateNo;
    /** 保安员证书ID */
    private Long securityCertificateId;
    /** 上传单位 */
    @ModelAnnotation(getName="上传单位",column = "uploadCompanyName")
    private String uploadCompanyName;
    /** 培训种类 */
    @ModelAnnotation(getName="培训种类",column = "trainType")
    private String trainType;
    /***
     * 用户ID
     */
    @ModelAnnotation(getName="用户ID",column = "userId")
    private Long userId;

    /**
     * 是否已推送给saas
     */
    private Boolean push;

    /**
     * 推送日期
     */
    private Date pushDate;
    /***
     * 培训开始时间
     */
    @ModelAnnotation(getName="培训开始时间",column  = "trainTime",sign = SignType.DATE_GREATER_EQUAL)
    private String trainStartTime;

    /***
     * 培训结束时间
     */
    @ModelAnnotation(getName="培训结束时间",column  = "trainTime",sign = SignType.DATE_LESS_EQUAL)
    private String trainEndTime;

    /***
     * 鉴定开始时间
     */
    @ModelAnnotation(getName="鉴定开始时间",column  = "appraisalTime",sign = SignType.DATE_GREATER_EQUAL)
    private String appraisalStartTime;

    /***
     * 鉴定结束时间
     */
    @ModelAnnotation(getName="鉴定结束时间",column  = "appraisalTime",sign = SignType.DATE_LESS_EQUAL)
    private String appraisalEndTime;

    /**
     * 在职状态
     */
    @ModelAnnotation(getName="在职状态",column  = "jobStatus",isExport = true,needTranslate = true,dictName = "incumbencyStatus")
    private String jobStatus;
}
