package com.bcxin.ars.dto.bj;

import lombok.Data;

import javax.xml.bind.annotation.*;

/***
 * 查询北京人员基本信息返回xml转换对象
 * @author subh
 */
/**
 * 属性才能被转换成xml中的标签
 */
@XmlAccessorType(XmlAccessType.FIELD)
/**
 * 指定根目录
 */
@XmlRootElement(name = "res")
/***
 * XmlType 默认情况下，Jaxb编组出来的xml中的字段顺序是随机的，你可以使用@XmlType的propOrder属性
 */
@XmlType
@Data
public class PersonInfo {
   /* String result = "<res><personid>ZK_52788678</personid>" +
            "<personname>吴金收</personname>" +
            "<personsex>1</personsex>" +
            "<dictguoji>156</dictguoji>" +
            "<age>52</age>" +
            "<minzu>01</minzu>" +
            "<personcardnumber>132201196402037013</personcardnumber>" +
            "<personhuji>河北省南宫市青年大街凤岗巷12号</personhuji>" +
            "<dsname>暂住人口表</dsname>" +
            "<ds>3</ds>" +
            "<picid/>" +
            "<xzqh>132201</xzqh>" +
            "</res>";*/
    /**
     * 人员ID
     */
    @XmlElement(name = "personid")
    private String personid;
    /***
     * 人员姓名
     */
    @XmlElement(name = "personname")
    private String personname;
    /***
     * 人员身份证
     */
    @XmlElement(name = "personcardnumber")
    private String personcardnumber;
    /***
     * 人员户籍
     */
    @XmlElement(name = "personhuji")
    private String personhuji;

    /***
     * 性别
     */
    @XmlElement(name = "personsex")
    private String personsex;
    @XmlElement(name = "dictguoji")
    private String dictguoji;
    /***
     * 年龄
     */
    @XmlElement(name = "age")
    private String age;
    @XmlElement(name = "minzu")
    private String minzu;
    @XmlElement(name = "dsname")
    private String dsname;
    @XmlElement(name = "ds")
    private String ds;
    @XmlElement(name = "picid")
    private String picid;
    @XmlElement(name = "xzqh")
    private String xzqh;
    @XmlElement(name = "xp")
    private String xp;

    /***
     * 警号
     */
    private String userid;
    /***
     * 身份证号
     */
    private String key;
}
