package com.bcxin.ars.dto.appraise;

import lombok.Data;

import java.io.Serializable;

/**
 * 评价详情
 * @author linqinglin
 * @date 2020/10/15 0015 11:59
 */
@Data
public class AppraiseDetailDto implements Serializable {

    private String id;// 主键标识 是
    private String appraiseNo;//    评价编号    否（改版后的必    有）
    private String serviceCode;//    服务编号    否（改版后的必    有）
    private String deptCode;// 统一社会信用            代码    是
    private String taskCode;// 事项编码 是
    private String taskHandleItem;//    业务办理项编            码    否（如果该事项            为业务办理项则    必须上传）
    private String taskName;// 事项名称 是
    private String subMatter;// 事项主题 否
    private String taskguid;// 事项唯一标识 是
    private String projectNo;//    办件编号    是 （ 应 按《 C0109.2-2018国家政务服务平台政务服务事项基本目录及实施清单 第2部分：要素要求》要求使用31位实施编码、8位办件申请    时 间 代 码（YYYYMMDD）、4    位顺序号三部分            组成新的办件编号）
    private String proDepart;// 受理部门 是28 / 74
    private String proManager;// 经办人 是

    // 访问渠道（pc端=1，移动端=2，二维码=3，政务大厅平板电脑=4，政务是29 / 74    大厅其他终端=5）
    // 评价渠道（超    期 默 认 好 评=0，pc端=1，移动端=2，二维码=3，政务大厅 平 板 电 脑=4，政务大厅其他终端=5） 是
    private String pf;
    private String certKey;// 评价人身份唯    一标识 是
    private String certKeyGOV;//    公共区身份证            号字段    是（互联网区上            传数据时要上传    评 价 人 的
    private String certkey;//政务外 网环境传输数据    时 要 上 传    certkeyGOV）
    private String userName;// 用户姓名 是
    private String userPageType;// 申请人证件类    型 否（改版后的必    有）
    private String userProp;// 用户属性（个            人=1、法人=2） 是
    private String handleUserName;// 代理人姓名 否
    private String handleUserPageType;// 代理人证件类    型 否
    private String handleUserPageCode;// 代理人证件号    码 否
    private String satisfaction;// 整 体 满 意 度（1-5） 是
    private String evalDetail;// 评价详情（勾选的评价详情    编号，勾选多    个 用 逗 号 隔    开。例：501，            503，504） 否
    private String phonumber;// 手机号 否
    private String writingEvaluation;// 文字评价 否
    private String proStatus;// 办件状态 是
    private Integer assessNumber;//  评价次数（与    服 务 次 数 一    致）    否（改版后的必    有）
    private Integer appStatus; //审核状态（1无            需审核0未审    核2通过3未通    过）    是
    private String rectification;// 整改反馈 否
    private Integer appovert;// 是否公开（公            开=1，不公开=2） 否
    private Integer promisetime;//  即办件=1，承            诺办件=2    是
    private String flag;// 操作类型（约    定该值为“I”，    修 改 接 口 为“U”）    是
    private String dataSource;// 数据来源由三    位数字组成。    其中，第1位填    写：            0：部门/1：    地方    第2、3位填写：    当第1位是    部门时，填写2    位 的 部 门 编    码，代码集为“中央部门编    码”；    当第1位是    地方时，填写2    位 的 省 级 区    划，代码集为“区划代码”。    是
    private String userid;// 评价用户我方            系统id    否
    private String create_time;// 创建时间 是30 / 74
    private String assessTime;// 评价时间 是
    private String checks;// 审核是否通过1:未通过 0:    通过 3未审批            否
    private String feedback;// 审批反馈 否
    private String acceptDate;// 收件时间 是，格式：yyyy�MM-dd HH:mm:ss
    private String dataly;// 数据来源（网    上大厅-1，政    务服务大厅- 2，其他系统- 3，系统默认- 4） 是
    private String sync_sign;// 同步标识 是
    private String effectivEvalua;// 是否为有效评    价数据（有效=1，无效=0） 否
    private String cd_Uptime;// 修改时间 否
    private String telPhone;// 评价联系人手            机号    否（改版后，如果    是差评则必有）
    private String source;// 评价数据入库            方标识
    private String feedBackId;//    差评反馈id    否（当该评价为差评反馈追评    时，对应的那条    差评反馈的id，    该字段作为区分            一条评价数据是初评还是追评的    依据。该字段值    不为空时，认为            该条数据为追评    数据，否则为初    评数据）
    private String feedBackNo;// 差评反馈对应    的原评价编号 否
    private String sourceTJ;// 评价提交方标            识
    private String administrative_div;// 行政区划代码 否（改版后的必    有）
    private String appraiseType;// 评价类型 咨    询评价、申报    评价、补正评    否（改版后的必    有）            31 / 74    价、缴费评价、    签收评价
    private String isDefault;// 是否默认评价1-是 0-否    否（改版后的必    有）
    private String areaCode;// 6位行政区划    代码 否
}
