package com.bcxin.ars.dto;

import org.springframework.util.StringUtils;

import com.bcxin.ars.model.SecurityCompany;

/**
 * 公司搜索类
 * @author Ethan
 */
public class CompanySearchDto extends SearchDto<SecurityCompany> {

	//保安公司参数开始
	private Long companyId;
	
	private String comArea;
	
	private String comScale;
	
	private String comLevel;
	
	private String[] securityScopes;
	
	private String[] natives;
	//保安公司参数结束
	
	//保安公司管理列表查询开始
	private String name;
	
	private String socialCode;
	
	private String legalPerson;
	
	private String phone;
	
	private String location;
	
	private String areaCode;

	private String orgLevel;
	//保安公司管理列表查询结束
	public Long getCompanyId() {
		return companyId;
	}

	public void setCompanyId(Long companyId) {
		this.companyId = companyId;
	}

	public String getComArea() {
		return comArea;
	}

	public void setComArea(String comArea) {
		this.comArea = comArea;
	}

	public String getComScale() {
		return comScale;
	}

	public void setComScale(String comScale) {
		if(comScale.indexOf("-") > 0) {
			if(comScale.split("-")[0].equals("0")){
				this.comScale = "((security_amount >=" + comScale.replaceAll("-", " AND security_amount < ")+" )or security_amount is null)";
			}else{
				this.comScale = "security_amount >=" + comScale.replaceAll("-", " AND security_amount < ");
			}
		} else if(!StringUtils.isEmpty(comScale)){
			this.comScale = "security_amount = " + comScale;
		}else{
			this.comScale = comScale;
		}
	}

	public String getComLevel() {
		return comLevel;
	}

	public void setComLevel(String comLevel) {
		this.comLevel = comLevel;
	}

	public String[] getSecurityScopes() {
		return securityScopes;
	}

	public void setSecurityScopes(String[] securityScopes) {
		this.securityScopes = securityScopes;
	}

	public String[] getNatives() {
		return natives;
	}

	public void setNatives(String[] natives) {
		this.natives = natives;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getSocialCode() {
		return socialCode;
	}

	public void setSocialCode(String socialCode) {
		this.socialCode = socialCode;
	}

	public String getLegalPerson() {
		return legalPerson;
	}

	public void setLegalPerson(String legalPerson) {
		this.legalPerson = legalPerson;
	}

	public String getPhone() {
		return phone;
	}

	public void setPhone(String phone) {
		this.phone = phone;
	}

	public String getLocation() {
		return location;
	}

	public void setLocation(String location) {
		this.location = location;
	}

	public String getAreaCode() {
		return areaCode;
	}

	public void setAreaCode(String areaCode) {
		this.areaCode = areaCode;
	}

	public String getOrgLevel() {
		return orgLevel;
	}

	public void setOrgLevel(String orgLevel) {
		this.orgLevel = orgLevel;
	}

	
}
