package com.abcxin.smart.validator.constraint;

import com.abcxin.smart.validator.annotation.CardNumber;
import com.abcxin.smart.validator.util.IdcardValidator;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * 身份证号码验证器
 * Created by Dareen on 2018/3/24.
 */
public class CardNumberValidator implements ConstraintValidator<CardNumber, String> {
    @Override
    public void initialize(CardNumber cardNumber) {
        //默认值，初始化
    }

    /***
     * 验证方法
     * @param value 字段值
     * @param context
     * @return
     */
    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        //如果值为则返回false
        if (value == null) {
            return false;
        }
        IdcardValidator idcardValidator = new IdcardValidator();
        //验证身份证是否正确
        if (idcardValidator.isValidatedAllIdcard(value)) {
            return true;
        }
        return false;
    }
}