package com.bcxin.ars.webservice;

import com.abcxin.smart.validator.annotation.MinisterialAttr;
import com.abcxin.smart.validator.annotation.MinisterialEntity;
import com.bcxin.ars.enums.MinisterialDataFormat;
import lombok.Data;

/**
 * 保安服务公司出资人信息上报实体类
 *
 * @author Wangjianchi
 */
@Data
@MinisterialEntity(tableName = "sb_investor", extraWhere = "and USERID in (select security_company.user_id from security_company where institutionType = '0102')")
public class Bafwgsczrxx extends XxbaBaseDto {
    /**
     * 保安服务公司编码
     */
    @MinisterialAttr(column = "(select companyCode from security_company where security_company.active = TRUE and security_company.USER_ID = t1.USERID)", isSubQuery = true)
    private String bagsbm;
    /**
     * 是否法人股东
     */
    @MinisterialAttr(column = "if((select t11.id from sb_management_info t11 where t11.user_id = t1.userid and t11.active and t1.id_number = t11.manager_id and (job_name like '%法人%' or job_name like '%法定代表人%') limit 1) is null , 0, 1)", isSubQuery = true)
    private String sffr;
    /**
     * 法人股东名称
     */
    private String frmc;
    /**
     * 法人股东经济类型
     */
    private String jllx;
    /**
     * 股东证件号码
     */
    @MinisterialAttr(column = "id_number")
    private String gdsfzh;
    /**
     * 自然人股东姓名
     */
    @MinisterialAttr(column = "`name`")
    private String gdxm;
    /**
     * 国籍（地区
     */
    @MinisterialAttr(column = "national")
    private String gj;
    /**
     * 证件类型
     */
    @MinisterialAttr(column = "idCardType", DATA_FORMAT = MinisterialDataFormat.INVESTOR_CARD_TYPE)
    private String zjlx;
    /**
     * 证件号码
     */
    @MinisterialAttr(column = "id_number")
    private String zjhm;
    /**
     * 性别
     */
    @MinisterialAttr(column = "id_number", DATA_FORMAT = MinisterialDataFormat.GENDER)
    private String xb;
    /**
     * 出生日期
     */
    @MinisterialAttr(column = "id_number", DATA_FORMAT = MinisterialDataFormat.BIRTH)
    private String csrq;
    /**
     * 民族
     */
    @MinisterialAttr(column = "nation")
    private String mz;
    /**
     * 户籍地详址
     */
    @MinisterialAttr(column = "huji")
    private String xxdz;
    /**
     * 出资金额
     */
    @MinisterialAttr(column = "funded_number", DATA_FORMAT = MinisterialDataFormat.CONVERSION_TO_YUAN)
    private String zzje;
    /**
     * 所占股份比例
     */
    @MinisterialAttr(column = "stock_proportion", DATA_FORMAT = MinisterialDataFormat.CONVERSION_TO_PERCENT)
    private String szbl;
    /**
     * 备注1
     */
    private String bz1;
    /**
     * 备注2
     */
    private String bz2;
    /**
     * 备注3
     */
    private String bz3;

    @Override
    public String toString() {
        return "Bafwgsczrxx{" +
                "bagsbm='" + bagsbm + '\'' +
                ", sffr=" + sffr +
                ", frmc='" + frmc + '\'' +
                ", jllx='" + jllx + '\'' +
                ", gdsfzh='" + gdsfzh + '\'' +
                ", gdxm='" + gdxm + '\'' +
                ", gj='" + gj + '\'' +
                ", zjlx='" + zjlx + '\'' +
                ", zjhm='" + zjhm + '\'' +
                ", xb=" + xb +
                ", csrq=" + csrq +
                ", mz='" + mz + '\'' +
                ", xxdz='" + xxdz + '\'' +
                ", zzje=" + zzje +
                ", szbl=" + szbl +
                ", bz1='" + bz1 + '\'' +
                ", bz2='" + bz2 + '\'' +
                ", bz3='" + bz3 + '\'' +
                '}';
    }
}
