package com.bcxin.ars.webservice;

import com.abcxin.smart.validator.annotation.MinisterialAttr;
import com.abcxin.smart.validator.annotation.MinisterialEntity;
import com.bcxin.ars.enums.MinisterialDataFormat;
import lombok.Data;

/**
 * 表彰奖励情况基本信息
 *
 * @author llc
 */
@Data
@MinisterialEntity(tableName = "company_award")
public class Babzjlxx extends XxbaBaseDto {

    /**
     * 被表彰奖励对象编码
     */

    @MinisterialAttr(column = "(select companyCode from security_company sc where sc.id = t1.company_id and sc.active=1)", isSubQuery = true)
    private String bjldxbm;
    /**
     * 被表彰奖励对象类别
     */
    @MinisterialAttr(column = "institutionType", DATA_FORMAT = MinisterialDataFormat.INSTITUTION_TYPE)
    private String bjldxlb;
    /**
     * 表彰奖励事迹
     */
    @MinisterialAttr(column = "reason")
    private String jlsj;
    /**
     * 表彰奖励形式
     */
    @MinisterialAttr(column = "content")
    private String jlxs;
    /**
     * 表彰奖励级别
     */
    private String jljb;
    /**
     * 表彰奖励日期
     */
    @MinisterialAttr(column = "award_date")
    private String jlrq;
    /**
     * 表彰奖励单位名称
     */
    @MinisterialAttr(column = "org_name")
    private String jldwmc;
    /**
     * 备注1
     */
    private String bz1;
    /**
     * 备注2
     */
    private String bz2;
    /**
     * 备注3
     */
    private String bz3;


    @Override
    public String toString() {
        return "Babzjlxx{" +
                "bjldxbm='" + bjldxbm + '\'' +
                ", bjldxlb='" + bjldxlb + '\'' +
                ", jlsj='" + jlsj + '\'' +
                ", jlxs='" + jlxs + '\'' +
                ", jljb='" + jljb + '\'' +
                ", jlrq='" + jlrq + '\'' +
                ", jldwmc='" + jldwmc + '\'' +
                ", bz1='" + bz1 + '\'' +
                ", bz2='" + bz2 + '\'' +
                ", bz3='" + bz3 + '\'' +
                '}';
    }
}
