package com.bcxin.ars.strategy.ministerial;

import com.abcxin.smart.validator.annotation.MinisterialAttr;

import java.lang.reflect.Field;

/**
 * 职业技能等级
 * @author zhangyutong
 */
public class JobLevelMinDataFormatStrategy implements MinDataFormatStrategy{
    @Override
    public String format(Field columnField, Object data) {
        if(data == null){
            MinisterialAttr resource = columnField.getAnnotation(MinisterialAttr.class);
            return resource.defaultValue();
        }
        switch (String.valueOf(data)) {
            case "1" :
                // 初级保安员
                return "10";
            case "2" :
                // 中级保安员
                return "20";
            case "3" :
                // 高级保安员
                return "30";
            case "4" :
                // 保安师
                return "40";
            case "5" :
                // 高级保安师
                return "50";
            default:
                return "10";
        }
    }
}
