package com.bcxin.ars.strategy.ministerial;

import com.abcxin.smart.validator.annotation.MinisterialAttr;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

/**
 * @author linqinglin
 * @date 2021/03/10 0010 10:49
 */
public class CompanyTypeFormatStrategy implements MinDataFormatStrategy {
    @Override
    public String format(Field columnField, Object data) {

        if(data == null){
            MinisterialAttr resource = columnField.getAnnotation(MinisterialAttr.class);
            return resource.defaultValue();
        }

        /**
         * 公司类型
         * 1:国有资本；
         * 2：民营；
         * 3：外资（包括港澳台投资）；
         * 4：其他
         */

        Map<String,String> comTypeMap = new HashMap<>();
        comTypeMap.put("1","4");//合资
        comTypeMap.put("2","4");//独资
        comTypeMap.put("3","1");//国有
        comTypeMap.put("4","2");//私营
        comTypeMap.put("5","2");//全民所有制
        comTypeMap.put("6","4");//集体所有制
        comTypeMap.put("7","4");//股份制
        comTypeMap.put("8","4");//有限责任
        comTypeMap.put("9","4");//其他


        return comTypeMap.get(data);
    }
}
