package com.bcxin.ars.strategy.ministerial;

import com.abcxin.smart.validator.annotation.MinisterialAttr;

import java.lang.reflect.Field;
import java.math.BigDecimal;

/**
 * 万元金额转元
 * @author linqinglin
 * @date 2021/03/09 0009 16:17
 */
public class AmountFormatStrategy implements MinDataFormatStrategy {
    @Override
    public String format(Field columnField, Object data) {
        if(data == null){
            MinisterialAttr resource = columnField.getAnnotation(MinisterialAttr.class);
            return resource.defaultValue();
        }
        return new BigDecimal(data.toString()).multiply(BigDecimal.valueOf(10000L)).toString();
    }

    public static void main(String[] args) {
        Object data = "20.1";
        System.out.println(new BigDecimal(data.toString()).multiply(BigDecimal.valueOf(10000L)).toString());
    }
}
