package com.bcxin.ars.model.task;

import com.bcxin.ars.model.BaseModel;
import com.bcxin.ars.model.SecurityPerson;
import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

/**
 * 子任务日志表
 * @author zhangye
 * @version V1.0.9
 */
public class TaskFeedbackLog extends BaseModel {

	private static final long serialVersionUID = 238419627952432L;
	
	 
	/**
	 * 子任务
	 */
	private TaskFeedback taskFeedback;
	
	
	/**
	 * 值班状态
	 */
	private String dutyState;//1正常2离岗3下班

	/**
	 * 离岗原因类别
	 */
	private String leaveType;//1执行紧急任务2提前完成任务3请假4其他

	/**
	 * 保安员
	 */
	@JsonBackReference
	@JsonIgnoreProperties(value={"handler"})
	private SecurityPerson person;
	
	/**
	 * 离岗原因
	 */
	private String leaveComment;
	
	/**
	 * 反馈信息
	 */
	private String comment;
	/**
	 * 反馈图片
	 */
	private String image;
	
	
	/**
	 * 紧急任务ID(非数据库字段)
	 * 如果传递紧急任务ID则会进行签到
	 */
	private Long taskId;
	 
	
	public TaskFeedback getTaskFeedback() {
		return taskFeedback;
	}
	public void setTaskFeedback(TaskFeedback taskFeedback) {
		this.taskFeedback = taskFeedback;
	}
	public String getDutyState() {
		return dutyState;
	}
	public void setDutyState(String dutyState) {
		this.dutyState = dutyState;
	}
	public String getLeaveType() {
		return leaveType;
	}
	public void setLeaveType(String leaveType) {
		this.leaveType = leaveType;
	}
	public SecurityPerson getPerson() {
		return person;
	}
	public void setPerson(SecurityPerson person) {
		this.person = person;
	}
	public String getLeaveComment() {
		return leaveComment;
	}
	public void setLeaveComment(String leaveComment) {
		this.leaveComment = leaveComment;
	}
	public String getComment() {
		return comment;
	}
	public void setComment(String comment) {
		this.comment = comment;
	}
	public String getImage() {
		return image;
	}
	public void setImage(String image) {
		this.image = image;
	}
	public Long getTaskId() {
		return taskId;
	}
	public void setTaskId(Long taskId) {
		this.taskId = taskId;
	}
	 

	
}
