package com.bcxin.ars.model.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonManagedReference;

/**
 * 任务种类
 * @author Ethan
 */
public class TaskCatalog implements Serializable {

	private static final long serialVersionUID = 6373324969851170132L;

	private Long id;
	
	/**
	 * 种类名称
	 */
	private String catalog;
	
	/**
	 * 父类
	 */
	private Long parentId;
	
	/**
	 * 子类列表
	 */
	@JsonManagedReference
	@JsonIgnoreProperties(value={"handler"})
	private List<TaskCatalog> children = new ArrayList<TaskCatalog>();

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public String getCatalog() {
		return catalog;
	}

	public void setCatalog(String catalog) {
		this.catalog = catalog;
	}

	public Long getParentId() {
		return parentId;
	}

	public void setParentId(Long parentId) {
		this.parentId = parentId;
	}

	public List<TaskCatalog> getChildren() {
		return children;
	}

	public void setChildren(List<TaskCatalog> children) {
		this.children = children;
	}
	
}
