package com.bcxin.ars.model.task;

import com.bcxin.ars.model.BaseModel;
import com.bcxin.ars.serializer.LongJsonDeserializer;
import com.bcxin.ars.serializer.LongJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;
import java.util.Date;

/**
 * 企业班次规则
 *
 * @author yyx
 * @Date 2020-03-26 09:39:07
 */
@Data
public class ComShiftRule extends BaseModel {

    private static final long serialVersionUID = 1L;
    /**
    * 班次规则ID
    * 
    */
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long shiftRuleId;
    /**
    * 企业ID
    * 
    */
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long comId;
    /**
    * 是否逻辑删除
    * 
    */
    private String isDelete;
    /**
    * 上下班第几轮
    * 
    */
    private Integer commutRound;
    /**
    * 上班时间
    * 
    */
    private Date startWorkTime;
    /**
    * 下班时间
    * 
    */
    private Date endWorkTime;
    /**
    * 上班时间是否是次日
    * 
    */
    private String isStartNextDay;
    /**
    * 下班时间是否是次日
    * 
    */
    private String isEndNextDay;
    /**
    * 班次ID
    * 
    */
    private Long shiftId;


    @Override
    public boolean equals (Object o){
        boolean retVal = false;
        if (o != null && o.getClass().equals(this.getClass())) {
            ComShiftRule that = (ComShiftRule) o;
            if (that.getShiftRuleId() != null && this.getShiftRuleId() != null){
                if (that.getShiftRuleId().intValue() == this.getShiftRuleId().intValue()
                        && that.getUpdateTime().getTime() >= this.getUpdateTime().getTime()) {
                    retVal = true;
                }
            }
        }
        return retVal;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}