package com.bcxin.ars.model.task;

import com.bcxin.ars.dto.task.TaskAppNoticeDto;
import com.bcxin.ars.model.BaseModel;
import com.bcxin.ars.serializer.LongJsonDeserializer;
import com.bcxin.ars.serializer.LongJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

/**
 * APP-消息通知
 * @author zhangye
 * @version V1.0.9
 */
public class AppNotice extends BaseModel {

 
	private static final long serialVersionUID = 7146969354989132832L;

	/**
	 * 通知分类ID
	 */
	private Long noticeTypeID;
	
	/**
	 * 通知标题
	 */
	private String noticeTitle;
	
	
	/**
	 * 通知内容
	 */
	private String noticeContent; 
	
	
	/**
	 * 链接地址
	 */
	private String linkurl;
	
	/**
	 * 保安人员ID
	 */
	@JsonSerialize(using = LongJsonSerializer.class)
	@JsonDeserialize(using = LongJsonDeserializer.class)
	private Long personId;

	/**
	 * 阅读情况(0:未读，1：已读)
	 */
	private String readStatus;

	 
	/**
	 * 任务ID
	 */
	private Long taskID;

	 
	/**
	 * 任务详情
	 */
	private TaskAppNoticeDto task;

	


	public Long getNoticeTypeID() {
		return noticeTypeID;
	}


	public void setNoticeTypeID(Long noticeTypeID) {
		this.noticeTypeID = noticeTypeID;
	}


	public String getNoticeTitle() {
		return noticeTitle;
	}


	public void setNoticeTitle(String noticeTitle) {
		this.noticeTitle = noticeTitle;
	}


 


	public String getNoticeContent() {
		return noticeContent;
	}


	public void setNoticeContent(String noticeContent) {
		this.noticeContent = noticeContent;
	}



	public String getLinkurl() {
		return linkurl;
	}


	public void setLinkurl(String linkurl) {
		this.linkurl = linkurl;
	}


	public Long getPersonId() {
		return personId;
	}


	public void setPersonId(Long personId) {
		this.personId = personId;
	}


	public String getReadStatus() {
		return readStatus;
	}


	public void setReadStatus(String readStatus) {
		this.readStatus = readStatus;
	}


	public Long getTaskID() {
		return taskID;
	}


	public void setTaskID(Long taskID) {
		this.taskID = taskID;
	}


	public TaskAppNoticeDto getTask() {
		return task;
	}


	public void setTask(TaskAppNoticeDto task) {
		this.task = task;
	}


	 
}
