package com.bcxin.ars.model.sys;


import com.bcxin.ars.model.BaseModel;
import lombok.Data;

import java.util.List;

/**
 * 功能权限表
 *
 * @author linqinglin
 * @Date 2020-03-27 14:35:21
 */
@Data
public class ModuleMenu extends BaseModel {

    private static final long serialVersionUID = 1L;
    /**
    * 菜单链接
    * 
    */
    private String location;
    /**
    * 节点文本
    * 
    */
    private String name;
    /**
    * 父节点ID
    * 
    */
    private Long parentId;
    /**
    * 同级菜单中排序序号
    * 
    */
    private Integer seq;
    /**
    * 结点类型：0菜单1权限
    * 
    */
    private String menuType = "0";
    /**
    * 功能的中文描述
    * 
    */
    private String description;
    /**
    * 主界面图标class
    * 
    */
    private String iconClass;
    /**
    * 图标class
    * 
    */
    private String iconCls;
    /**
    * 权限标识
    * 
    */
    private String permission;
    /**
    * 父节点的id列表，如"100001/100020/100022/"，分别列出从根开始的编码
    * 
    */
    private String parentIds;

    private String state = "closed";

    /**
     * 唯一标识id 页面跳转使用
     */
    private String uniqueId;

    /**
     * 内外网标识 0外网 1内网 2内外网
     */
    private String intranetFlag;

    /**
     * 是否仅超管可见 0否 1是
     */
    private String superAdmin;

    /**
     * 平台角色 1公安 2企业 4自然人
     */
    private String platform;

    /**
     * 职级权限 0职级查询 1全部开放
     */
    private String rankAuth;

    private List<ModuleMenu> children;

    @Override
    public boolean equals (Object o){
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}