package com.bcxin.ars.model.sx;

import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
@Data
public class StepDone {
    /** 主键，具体数据的唯一ID，中间库表之间数据的关联 */
    private String orgbusno;

    /** 主键，详见附录2.3 */
    private String projid;

    /** 主键，默认为1，用于重报数据的情况 */
    private String dataver;

    /** 编码规则见附录2.4 */
    private String region_id;

    /** 事项所属行政区划，编码规则见附录2.4 */
    private String itemregionid;

    /** 办结结果代码：0 – 出证办结（正常产生证照、批文的办结；准予许可的办结），1 – 不予许可，2 – 作废办结（指业务处理上无效的纪录），3 – 删除办结（指录入错误、操作错误等技术上的无效纪录），4 – 转报办结（指转报其他单位或上级单位的办结情况），5 – 退件（申请人长期不来补齐补正材料的办结；申请人主动放弃继续办理业务的办结），6 – 不予受理。 */
    private String doneresult;

    /** 在办结结果是上述的1、2、3、4、5时，本字段必须写明原因。 */
    private String exitres;

    /** 行政许可决定书文号 */
    private String approvalnumber;

    /** 行政许可决定书有效期限 */
    private Date approvallimit;

    /** 提供的有效证件名称，详见附录2.5 */
    private Byte cardtype;

    /** 如果出证办结，必须有证件编号 */
    private String certificateno;

    /** 如果出证办结，必须有 */
    private String certificatelimit;

    /** GB/T 19488.2-2008中机构名称。 */
    private String publisher;

    /** 1-是，0-否。 */
    private String isfee;

    /** GB/T 19488.2-2008中金额。 */
    private BigDecimal fee;

    /** 如果收费  */
    private String feestandard;

    /** 如果收费 */
    private String feestandaccord;

    /** GB/T 19488.2-2008中姓名。 */
    private String paypersonname;

    /** GB/T 19488.2-2008中身份证件号码。 */
    private String payperidcard;

    /** GB/T 19488.2-2008中移动电话。 */
    private String payermobile;

    /** GB/T 19488.2-2008中联系电话。 */
    private String payertel;

    /** 环节发生时间 */
    private Date occurtime;

    /** 环节办理人 */
    private String transactor;

    /** 进入数据库时间，默认为系统时间 */
    private Date maketime;

    /** 数据交换状态标志位，默认为0 */
    private Long signstate;

    /**  */
    private String errorcode1;

    /**  */
    private String errormsg1;

    /**  */
    private String status1;

    /** 由于存在同一事项多系统办理的情况，需要明确数据来源具体系统 */
    private String sysmark;

    /**  */
    private Date localtime;

    /** 同步类型 */
    private String cd_operation;

    /** 是否快递递送结果 */
    private String isdeliveryresults;

    /** 满意度根据国家平台规范添加：见C0126.1 附录C.30 */
    private String satisfaction;

    /**  */
    private String resultcetrname;

}