package com.bcxin.ars.model.sx;

import lombok.Data;

import java.util.Date;
@Data
public class Apasinfo {
    /** 主键，详见附录2.3 */
    private String projid;

    /** 由业务系统随机自动生成的数字，如：234765  */
    private String projpwd;

    /** 详见附录2.1 */
    private String item_code;

    /** 详见附录2.2 */
    private String implement_code;

    /** 审批事项的版本号 */
    private String itemversion;

    /** 申报的事项名称，如：交通建设工程施工许可 */
    private String itemname;

    /** 申请审批的项目的具体名称。如：关于XXX的交通建设工程施工许可 */
    private String projectname;

    /** 详见附录2.7 办件状态代码*/
    private String projectstate;

    /** 1-即办件，2-承诺件，3-联办件，4-上报件。 */
    private String infotype;

    /** GB/T 19488.2-2008中姓名或
机构名称。
 */
    private String applyname;

    /** GB/T 19488.2-2008中身份证件号码 */
    private String apply_cardtypenumber;

    /** GB/T 19488.2-2008中姓名。 */
    private String contactman;

    /** GB/T 19488.2-2008中身份证件号码 */
    private String contactman_cardnumber;

    /** GB/T 19488.2-2008中移动号码 */
    private String telphone;

    /** GB/T 19488.2-2008中邮政编码 */
    private String postcode;

    /** GB/T 19488.2-2008中通信地址 */
    private String address;

    /** GB/T 19488.2-2008中法定代表人 */
    private String legalman;

    /** GB 32100-2015中统一社会信用代码。 */
    private String deptid;

    /** GB/T 19488.2-2008中机构名称。 */
    private String deptname;

    /** 创建用户唯一标识 */
    private String receive_useid;

    /** 创建用户名称 */
    private String receive_name;

    /** GB/T 19488.2-2008中时间。 */
    private Date receivetime;

    /** 审批类型 */
    private String approve_type;

    /** 申报者行政区划 */
    private String region_id;

    /** 0-作废，1-有效。 */
    private String  datastate;

    /** 数据产生时间YYYY-MM-DDHH24:MI:SS。 */
    private Date create_time;

    /** 主键，默认值=1，如果有信息变更，则版本号递增 */
    private String dataver;

    /** 进入数据库时间，默认为系统时间 */
    private Date maketime;

    /** 数据交换状态标志位，默认为0 */
    private Long signstate;

    /** 第三方系统个人中心URL */
    private String centerurl;

    /** 系统标识 */
    private String sysmark;

    /**  */
    private Date localtime;

    /** 同步类型 I-插入，U-更新，D-删除 */
    private String cd_operation;

    /** 申报者证件类型 */
    private String apply_cardtype;

    /** 申报来源 */
    private String applyfrom;

    /** 联系人/代理人证件类型 根据国家平台规范修改：代码集见C0126.1 附录C.34 */
    private String contactman_cardtype;

    /**参照陕西省全省事项库规范字段sourceid，为保证事项信息准确性最新添加  */
    private String sourceid;

    /** 格式为 ID:NAME,ID:NAME,··· */
    private String acceptlist;

}