package com.bcxin.ars.model.sb;


import com.bcxin.ars.model.BaseModel;
import lombok.Data;

import java.util.Date;

/**
 * 保安员岗位适应性报名
 *
 * @author linqinglin
 * @Date 2020-04-10 10:39:21
 */
@Data
public class PersonAdapt extends BaseModel {

    private static final long serialVersionUID = 1L;
    /**
     * 公安机关id
     *
     */
    private Long orgId;
    /**
     * 人员id
     *
     */
    private Long personId;
    /**
     * 姓名
     *
     */
    private String name;
    /**
     * 手机号
     *
     */
    private String phone;
    /**
     * 身份证号
     *
     */
    private String idNum;
    /**
     * 报名时间
     *
     */
    private Date applyTime;
    /**
     * 培训机构id
     *
     */
    private Long trainId;
    /**
     * 培训机构
     *
     */
    private String trainName;
    /**
     * 公司id
     *
     */
    private Long comId;
    /**
     * 公司名称
     *
     */
    private String comName;
    /**
     * 学时进度
     *
     */
    private String period;
    /**
     * 学时进度状态
     *
     */
    private String periodStatus;
    /**
     * 背景筛查状态
     *
     */
    private String censorStatus;
    /**
     * 户籍地址
     *
     */
    private String address;
    /**
     * 现住地址
     *
     */
    private String liveAddress;
    /**
     * 户籍类型
     *
     */
    private String residentType;
    /**
     * 户籍所在地类型
     *
     */
    private String residentPlaceType;
    /**
     * 合同id
     *
     */
    private Long contractId;
    /**
     * 缴费时间
     *
     */
    private Date payTime;
    /**
     * 缴费状态
     *
     */
    private String payState;
    /**
     * 材料核对状态
     *
     */
    private String checkState;
    /**
     * 材料核对时间
     *
     */
    private Date checkDate;
    /**
     * 审批原因
     *
     */
    private String approvalReason;
    /**
     * 审批状态
     *
     */
    private String approvalState;
    /**
     * 户籍所在区县人力社保部门开据的确认证明
     *
     */
    private String confirmCerUrl;


    @Override
    public boolean equals (Object o){
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}