package com.bcxin.ars.model.sb;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.bcxin.ars.model.BusinessCommon;

import java.util.Date;

/**
 *sb_crosscompany
 *跨区域经营保安服务备案
 *
 */
public class Crosscompany extends BusinessCommon {

	/**  */
	private static final long serialVersionUID = -1641028410052142002L;

    /**
    *地址
    */
	@ModelAnnotation(getName="地址",isExport = true,column  = "address")
    private String address;

    /**
    *保安许可服务证号
    */
	@ModelAnnotation(getName="保安许可服务证号",isExport = true,column  = "Licencenum")
    private String licencenum;

    /**
    *邮编
    */
	@ModelAnnotation(getName="邮编",isExport = true,column  = "Zipcode")
    private String zipcode;

    /**
    *统一社会信用号码
    */
	@ModelAnnotation(getName="统一社会信用号码",isExport = true,column  = "Creditcode")
    private String creditcode;

    /**
    *法人姓名
    */
	@ModelAnnotation(getName="法人姓名",isExport = true,column  = "Legalname",defaultColumn = true)
    private String legalname;

    /**
    *法人性别
    */
	@ModelAnnotation(getName="法人性别",isExport = true,column  = "Legalsex",needTranslate = true,dictName = "sex")
    private String legalsex;

    /**
    *法人民族
    */
	@ModelAnnotation(getName="法人民族",isExport = true,column  = "Legalnation")
    private String legalnation;

    /**
    *法人出生年月
    */
	@ModelAnnotation(getName="法人出生年月",isExport = true,column  = "Legalbirth")
    private Date legalbirth;

    /**
    *法人政治面貌
    */
	@ModelAnnotation(getName="法人政治面貌",isExport = true,column  = "legalPolitics",needTranslate = true,dictName ="politics" )
    private String legalpolitics;

    /**
    *法人文化程度
    */
	@ModelAnnotation(getName="法人文化程度",isExport = true,column  = "legalCulture",needTranslate = true,dictName = "edu")
    private String legalculture;

    /**
    *法人办公电话
    */
	@ModelAnnotation(getName="法人办公电话",isExport = true,column  = "Legaltel")
    private String legaltel;

    /**
    *法人手机
    */
	@ModelAnnotation(getName="法人手机",isExport = true,column  = "Legalphone",defaultColumn = true)
    private String legalphone;

    /**
    *法人国籍
    */
	@ModelAnnotation(getName="法人国籍",isExport = true,column  = "Legalnationality")
    private String legalnationality;

    /**
    *法人证件类型
    */
	@ModelAnnotation(getName="法人证件类型",isExport = true,column  = "Legaltype",needTranslate = true,dictName = "idCardType")
    private String legaltype;

    /**
    *法人证件号码
    */
	@ModelAnnotation(getName="法人证件号码",isExport = true,column  = "Legalcardnumber")
    private String legalcardnumber;

    /**
    *法人实际居住地址
    */
	@ModelAnnotation(getName="法人实际居住地址",isExport = true,column  = "Legaladdress")
    private String legaladdress;

    /**
    *法人户籍所在址/境外地址
    */
	@ModelAnnotation(getName="法人户籍所在址/境外地址",isExport = true,column  = "legalAbroadaddress")
    private String legalabroadaddress;

    /**
    *拟跨区域经营的
    */
	@ModelAnnotation(getName="拟跨区域经营的",isExport = true,column  = "Managerproject")
    private String managerproject;

    /**
    *跨区域经营服务开始时间
    */
	@ModelAnnotation(getName="跨区域经营服务开始时间",isExport = true,column  = "Startdate")
    private Date startdate;

    /**
    *跨区域经营服务结束时间
    */
	@ModelAnnotation(getName="跨区域经营服务结束时间",isExport = true,column  = "enddate")
    private Date enddate;

    /**
    *拟跨区域经营地址
    */
	@ModelAnnotation(getName="拟跨区域经营地址",isExport = true,column  = "manageraddress")
    private String manageraddress;

    /**
    *负责人姓名
    */
	@ModelAnnotation(getName="负责人姓名",isExport = true,column  = "Chargename")
    private String chargename;

    /**
    *负责人职务
    */
	@ModelAnnotation(getName="负责人职务",isExport = true,column  = "Chargepost")
    private String chargepost;

    /**
    *负责人居民身份证号码
    */
	@ModelAnnotation(getName="负责人居民身份证号码",isExport = true,column  = "Chargecardnumber")
    private String chargecardnumber;

    /**
    *负责人联系电话
    */
	@ModelAnnotation(getName="负责人联系电话",isExport = true,column  = "Chargephone")
    private String chargephone;

    /**
    *子公司保安人数
    */
	@ModelAnnotation(getName="子公司保安人数",isExport = true,column  = "Sonpersonnum")
    private Integer sonpersonnum;

    /**
    *子公司邮编
    */
	@ModelAnnotation(getName="子公司邮编",isExport = true,column  = "Sonzipcode")
    private String sonzipcode;

	/**
	 * 法人审核状态
	 */
	@ModelAnnotation(getName="法人审核状态",isExport = true,column  = "legalcensorstatus",needTranslate = true,dictName = "censorStatus")
	private String legalcensorstatus;

	/**
	 *单位负责人审查状态(0 未审查 1 审查通过 2审查不通过）
	 */
	@ModelAnnotation(getName="单位负责人审查状态",isExport = true,column  = "chargecensorstatus",needTranslate = true,dictName = "censorStatus")
	private String chargecensorstatus;

	public String getLegalcensorstatus() {
		return legalcensorstatus;
	}

	public void setLegalcensorstatus(String legalcensorstatus) {
		this.legalcensorstatus = legalcensorstatus;
	}

	public String getChargecensorstatus() {
		return chargecensorstatus;
	}

	public void setChargecensorstatus(String chargecensorstatus) {
		this.chargecensorstatus = chargecensorstatus;
	}

	/**
	 *地址
	 */
	public String getAddress(){
		return this.address;
	}
	
	/**
	 *地址
	 */
	public void setAddress(String address){
		this.address = address;
	}
	/**
	 *保安服务许可证号
	 */
	public String getLicencenum(){
		return this.licencenum;
	}
	
	/**
	 *保安服务许可证号
	 */
	public void setLicencenum(String licencenum){
		this.licencenum = licencenum;
	}
	/**
	 *邮编
	 */
	public String getZipcode(){
		return this.zipcode;
	}
	
	/**
	 *邮编
	 */
	public void setZipcode(String zipcode){
		this.zipcode = zipcode;
	}
	/**
	 *统一社会信用号码
	 */
	public String getCreditcode(){
		return this.creditcode;
	}
	
	/**
	 *统一社会信用号码
	 */
	public void setCreditcode(String creditcode){
		this.creditcode = creditcode;
	}
	/**
	 *法人姓名
	 */
	public String getLegalname(){
		return this.legalname;
	}
	
	/**
	 *法人姓名
	 */
	public void setLegalname(String legalname){
		this.legalname = legalname;
	}
	/**
	 *法人性别
	 */
	public String getLegalsex(){
		return this.legalsex;
	}
	
	/**
	 *法人性别
	 */
	public void setLegalsex(String legalsex){
		this.legalsex = legalsex;
	}
	/**
	 *法人民族
	 */
	public String getLegalnation(){
		return this.legalnation;
	}
	
	/**
	 *法人民族
	 */
	public void setLegalnation(String legalnation){
		this.legalnation = legalnation;
	}
	/**
	 *法人出生年月
	 */
	public Date getLegalbirth(){
		return this.legalbirth;
	}
	
	/**
	 *法人出生年月
	 */
	public void setLegalbirth(Date legalbirth){
		this.legalbirth = legalbirth;
	}
	/**
	 *法人政治面貌
	 */
	public String getLegalpolitics(){
		return this.legalpolitics;
	}
	
	/**
	 *法人政治面貌
	 */
	public void setLegalpolitics(String legalpolitics){
		this.legalpolitics = legalpolitics;
	}
	/**
	 *法人文化程度
	 */
	public String getLegalculture(){
		return this.legalculture;
	}
	
	/**
	 *法人文化程度
	 */
	public void setLegalculture(String legalculture){
		this.legalculture = legalculture;
	}
	/**
	 *法人办公电话
	 */
	public String getLegaltel(){
		return this.legaltel;
	}
	
	/**
	 *法人办公电话
	 */
	public void setLegaltel(String legaltel){
		this.legaltel = legaltel;
	}
	/**
	 *
	 */
	public String getLegalphone(){
		return this.legalphone;
	}
	
	/**
	 *
	 */
	public void setLegalphone(String legalphone){
		this.legalphone = legalphone;
	}
	/**
	 *法人国籍
	 */
	public String getLegalnationality(){
		return this.legalnationality;
	}
	
	/**
	 *法人国籍
	 */
	public void setLegalnationality(String legalnationality){
		this.legalnationality = legalnationality;
	}
	/**
	 *法人证件类型
	 */
	public String getLegaltype(){
		return this.legaltype;
	}
	
	/**
	 *法人证件类型
	 */
	public void setLegaltype(String legaltype){
		this.legaltype = legaltype;
	}
	/**
	 *法人证件号码
	 */
	public String getLegalcardnumber(){
		return this.legalcardnumber;
	}
	
	/**
	 *法人证件号码
	 */
	public void setLegalcardnumber(String legalcardnumber){
		this.legalcardnumber = legalcardnumber;
	}
	/**
	 *法人实际居住地址
	 */
	public String getLegaladdress(){
		return this.legaladdress;
	}
	
	/**
	 *法人实际居住地址
	 */
	public void setLegaladdress(String legaladdress){
		this.legaladdress = legaladdress;
	}
	/**
	 *法人户籍所在址/境外地址
	 */
	public String getLegalabroadaddress(){
		return this.legalabroadaddress;
	}
	
	/**
	 *法人户籍所在址/境外地址
	 */
	public void setLegalabroadaddress(String legalabroadaddress){
		this.legalabroadaddress = legalabroadaddress;
	}
	/**
	 *拟跨区域经营的
	 */
	public String getManagerproject(){
		return this.managerproject;
	}
	
	/**
	 *拟跨区域经营的
	 */
	public void setManagerproject(String managerproject){
		this.managerproject = managerproject;
	}
	/**
	 *跨区域经营服务开始时间
	 */
	public Date getStartdate(){
		return this.startdate;
	}
	
	/**
	 *跨区域经营服务开始时间
	 */
	public void setStartdate(Date startdate){
		this.startdate = startdate;
	}
	/**
	 *跨区域经营服务结束时间
	 */
	public Date getEnddate(){
		return this.enddate;
	}
	
	/**
	 *跨区域经营服务结束时间
	 */
	public void setEnddate(Date enddate){
		this.enddate = enddate;
	}
	/**
	 *拟跨区域经营地址
	 */
	public String getManageraddress(){
		return this.manageraddress;
	}
	
	/**
	 *拟跨区域经营地址
	 */
	public void setManageraddress(String manageraddress){
		this.manageraddress = manageraddress;
	}
	/**
	 *负责人姓名
	 */
	public String getChargename(){
		return this.chargename;
	}
	
	/**
	 *负责人姓名
	 */
	public void setChargename(String chargename){
		this.chargename = chargename;
	}
	/**
	 *负责人职务
	 */
	public String getChargepost(){
		return this.chargepost;
	}
	
	/**
	 *负责人职务
	 */
	public void setChargepost(String chargepost){
		this.chargepost = chargepost;
	}
	/**
	 *负责人居民身份证号码
	 */
	public String getChargecardnumber(){
		return this.chargecardnumber;
	}
	
	/**
	 *负责人居民身份证号码
	 */
	public void setChargecardnumber(String chargecardnumber){
		this.chargecardnumber = chargecardnumber;
	}
	/**
	 *负责人联系电话
	 */
	public String getChargephone(){
		return this.chargephone;
	}
	
	/**
	 *负责人联系电话
	 */
	public void setChargephone(String chargephone){
		this.chargephone = chargephone;
	}
	/**
	 *子公司保安人数
	 */
	public Integer getSonpersonnum(){
		return this.sonpersonnum;
	}
	
	/**
	 *子公司保安人数
	 */
	public void setSonpersonnum(Integer sonpersonnum){
		this.sonpersonnum = sonpersonnum;
	}
	/**
	 *子公司邮编
	 */
	public String getSonzipcode(){
		return this.sonzipcode;
	}
	
	/**
	 *子公司邮编
	 */
	public void setSonzipcode(String sonzipcode){
		this.sonzipcode = sonzipcode;
	}
}